<?php

/**

 * Dashboard UI for GT BOGO Engine

 *

 * @package GT_BOGO_Engine

 */



if ( ! defined( 'ABSPATH' ) ) {

	exit;

}



$pro_active = ! empty( $is_pro );

$enabled    = ! empty( $settings['enabled'] );

$mode       = isset( $settings['mode'] ) ? $settings['mode'] : 'live';

?>



<div class="wrap gt-bogo-wrap">



	<div class="gt-bogo-header">

		<img src="<?php echo esc_url( GT_BOGO_ENGINE_URL . 'assets/img/logo-256.png' ); ?>" class="gt-bogo-logo" alt="GT BOGO Engine">

		<h1 class="gt-bogo-title">GT BOGO Engine</h1>

		<p class="gt-bogo-subtitle">Smart Buy X Get Y Discounts for WooCommerce</p>

	</div>



	<div class="gt-bogo-grid">



		<!-- STATUS CARD -->

		<div class="gt-bogo-card large">

			<h2 class="gt-bogo-card-title">Plugin Status</h2>



			<ul class="gt-bogo-status-list">

				<li>

					<strong>Engine Enabled:</strong>

					<span class="<?php echo $enabled ? 'status-ok' : 'status-off'; ?>">

						<?php echo $enabled ? 'Yes' : 'Disabled'; ?>

					</span>

				</li>



				<li>

					<strong>Mode:</strong>

					<span class="status-neutral">

						<?php echo ucfirst( esc_html( $mode ) ); ?>

					</span>

				</li>



				<li>

					<strong>PRO Active:</strong>

					<span class="<?php echo $pro_active ? 'status-ok' : 'status-off'; ?>">

						<?php echo $pro_active ? 'Yes' : 'No (Free Version)' ; ?>

					</span>

				</li>



				<li>

					<strong>WooCommerce:</strong>

					<span class="<?php echo class_exists( 'WooCommerce' ) ? 'status-ok' : 'status-error'; ?>">

						<?php echo class_exists( 'WooCommerce' ) ? 'Detected' : 'Not Installed'; ?>

					</span>

				</li>

			</ul>



			<a href="admin.php?page=gt-bogo-settings" class="button button-primary">

				Configure Settings

			</a>

		</div>





		<!-- QUICK ACTIONS CARD -->

		<div class="gt-bogo-card large">

			<h2 class="gt-bogo-card-title">Quick Actions</h2>



			<div class="gt-bogo-actions">

				<a href="admin.php?page=gt-bogo-free-rule" class="button button-secondary">

					Manage Free BOGO Rule

				</a>



				<a href="admin.php?page=gt-bogo-pro-rules" class="button button-secondary">

					Manage PRO Rules

				</a>



				<a href="admin.php?page=gt-bogo-system-status" class="button">

					System Status

				</a>

			</div>

		</div>



	</div>



	<!-- BRAND FOOTER -->

	<div class="gt-bogo-footer">

		<p>

			Plugin crafted by

			<a href="https://graphictshirts.shop" target="_blank" rel="noopener">GRAPHIC T-SHIRTS</a>

			· Premium WooCommerce Solutions

		</p>

	</div>



</div>
