<?php
/**
 * Free Rule settings page for GT BOGO Engine.
 *
 * @package GT_BOGO_Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Handle save.
$saved = false;

if (
	isset( $_POST['gt_bogo_free_rule_nonce'], $_POST['gt_bogo_free_rule'] )
	&& wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['gt_bogo_free_rule_nonce'] ) ), 'gt_bogo_save_free_rule' )
	&& current_user_can( 'manage_woocommerce' )
) {
	$raw = wp_unslash( $_POST['gt_bogo_free_rule'] );

	$rule = array(
		'enabled'        => ! empty( $raw['enabled'] ) ? 1 : 0,
		'buy_qty'        => isset( $raw['buy_qty'] ) ? max( 1, absint( $raw['buy_qty'] ) ) : 1,
		'get_qty'        => isset( $raw['get_qty'] ) ? max( 1, absint( $raw['get_qty'] ) ) : 1,
		'discount_type'  => in_array( $raw['discount_type'] ?? 'percent', array( 'percent', 'fixed' ), true ) ? $raw['discount_type'] : 'percent',
		'discount_value' => isset( $raw['discount_value'] ) ? max( 0, floatval( $raw['discount_value'] ) ) : 50,
		'scope'          => in_array( $raw['scope'] ?? 'all', array( 'all', 'categories', 'products' ), true ) ? $raw['scope'] : 'all',
		'categories'     => isset( $raw['categories'] ) ? sanitize_text_field( $raw['categories'] ) : '',
		'products'       => isset( $raw['products'] ) ? sanitize_text_field( $raw['products'] ) : '',
		'promo_message'  => isset( $raw['promo_message'] ) ? sanitize_text_field( $raw['promo_message'] ) : '',
	);

	update_option( 'gt_bogo_engine_free_rule', $rule );
	$saved = true;
}

// Load current rule.
$rule = get_option(
	'gt_bogo_engine_free_rule',
	array(
		'enabled'        => 1,
		'buy_qty'        => 1,
		'get_qty'        => 1,
		'discount_type'  => 'percent',
		'discount_value' => 50,
		'scope'          => 'all',
		'categories'     => '',
		'products'       => '',
		'promo_message'  => 'Buy 1 Get 1 50% Off – discount applied at checkout.',
	)
);

?>
<div class="wrap gt-bogo-wrap gt-bogo-page-free-rule">

	<div class="gt-bogo-header">
		<h1 class="gt-bogo-title">Free Global BOGO Rule</h1>
		<p class="gt-bogo-subtitle">
			This is the **included** free rule: a single global Buy X Get Y promotion automatically applied in the cart.
		</p>
	</div>

	<?php if ( $saved ) : ?>
		<div class="notice notice-success is-dismissible">
			<p><strong>Free BOGO rule updated.</strong> Your settings have been saved.</p>
		</div>
	<?php endif; ?>

	<div class="gt-bogo-grid">

		<!-- MAIN FORM -->
		<div class="gt-bogo-card xlarge">
			<h2 class="gt-bogo-card-title">Configure your free Buy X Get Y rule</h2>

			<form method="post" class="gt-bogo-form">
				<?php wp_nonce_field( 'gt_bogo_save_free_rule', 'gt_bogo_free_rule_nonce' ); ?>

				<table class="form-table gt-bogo-form-table" role="presentation">
					<tbody>

					<tr>
						<th scope="row">
							<label for="gt_bogo_enabled">Enable global BOGO rule</label>
						</th>
						<td>
							<label class="gt-bogo-switch">
								<input type="checkbox" name="gt_bogo_free_rule[enabled]" id="gt_bogo_enabled" <?php checked( ! empty( $rule['enabled'] ) ); ?>>
								<span class="gt-bogo-slider"></span>
							</label>
							<p class="description">
								When enabled, this rule will be evaluated on every cart and checkout.
							</p>
						</td>
					</tr>

					<tr>
						<th scope="row"><label>Buy / Get quantities</label></th>
						<td>
							<div class="gt-bogo-inline-fields">
								<div>
									<label for="gt_bogo_buy_qty" class="gt-bogo-label-small">Buy quantity</label>
									<input type="number" min="1" step="1" id="gt_bogo_buy_qty"
									       name="gt_bogo_free_rule[buy_qty]"
									       value="<?php echo esc_attr( $rule['buy_qty'] ); ?>">
								</div>
								<div>
									<label for="gt_bogo_get_qty" class="gt-bogo-label-small">Get quantity</label>
									<input type="number" min="1" step="1" id="gt_bogo_get_qty"
									       name="gt_bogo_free_rule[get_qty]"
									       value="<?php echo esc_attr( $rule['get_qty'] ); ?>">
								</div>
							</div>
							<p class="description">Example: Buy <strong>1</strong> get <strong>1</strong> at a discount.</p>
						</td>
					</tr>

					<tr>
						<th scope="row"><label>Discount style</label></th>
						<td>
							<div class="gt-bogo-inline-fields">
								<div>
									<label for="gt_bogo_discount_type" class="gt-bogo-label-small">Type</label>
									<select id="gt_bogo_discount_type" name="gt_bogo_free_rule[discount_type]">
										<option value="percent" <?php selected( $rule['discount_type'], 'percent' ); ?>>Percentage (%)</option>
										<option value="fixed" <?php selected( $rule['discount_type'], 'fixed' ); ?>>Fixed amount</option>
									</select>
								</div>
								<div>
									<label for="gt_bogo_discount_value" class="gt-bogo-label-small">Value</label>
									<input type="number" min="0" step="0.01" id="gt_bogo_discount_value"
									       name="gt_bogo_free_rule[discount_value]"
									       value="<?php echo esc_attr( $rule['discount_value'] ); ?>">
								</div>
							</div>
							<p class="description">
								For “Buy 1 Get 1 at 50% Off”, choose <strong>Percentage</strong> and set value to <strong>50</strong>.
							</p>
						</td>
					</tr>

					<tr>
						<th scope="row"><label>Apply to</label></th>
						<td>
							<select id="gt_bogo_scope" name="gt_bogo_free_rule[scope]">
								<option value="all" <?php selected( $rule['scope'], 'all' ); ?>>All products</option>
								<option value="categories" <?php selected( $rule['scope'], 'categories' ); ?>>Specific categories</option>
								<option value="products" <?php selected( $rule['scope'], 'products' ); ?>>Specific products</option>
							</select>
							<p class="description">Control where the rule is allowed to fire.</p>

							<div class="gt-bogo-conditional gt-bogo-scope-categories" <?php echo ( 'categories' === $rule['scope'] ) ? '' : 'style="display:none"'; ?>>
								<label for="gt_bogo_categories" class="gt-bogo-label-small">Category IDs or slugs</label>
								<input type="text" id="gt_bogo_categories"
								       name="gt_bogo_free_rule[categories]"
								       value="<?php echo esc_attr( $rule['categories'] ); ?>"
								       placeholder="e.g. hoodies, sale, 14, 22">
								<p class="description">Comma-separated; accepts category slugs or IDs.</p>
							</div>

							<div class="gt-bogo-conditional gt-bogo-scope-products" <?php echo ( 'products' === $rule['scope'] ) ? '' : 'style="display:none"'; ?>>
								<label for="gt_bogo_products" class="gt-bogo-label-small">Product IDs</label>
								<input type="text" id="gt_bogo_products"
								       name="gt_bogo_free_rule[products]"
								       value="<?php echo esc_attr( $rule['products'] ); ?>"
								       placeholder="e.g. 101, 202, 303">
								<p class="description">Comma-separated list of product IDs.</p>
							</div>
						</td>
					</tr>

					<tr>
						<th scope="row"><label for="gt_bogo_promo_message">Promo message (optional)</label></th>
						<td>
							<input type="text" class="regular-text"
							       id="gt_bogo_promo_message"
							       name="gt_bogo_free_rule[promo_message]"
							       value="<?php echo esc_attr( $rule['promo_message'] ); ?>">
							<p class="description">
								Shown in your theme where you output the rule label (for example on product or cart pages).
							</p>
						</td>
					</tr>

					</tbody>
				</table>

				<p class="submit">
					<button type="submit" class="button button-primary gt-bogo-save-btn">
						Save Free BOGO Rule
					</button>
				</p>

			</form>
		</div>

		<!-- SIDEBAR HELP -->
		<div class="gt-bogo-card medium gt-bogo-help-card">
			<h2 class="gt-bogo-card-title">How the free rule works</h2>
			<ul class="gt-bogo-help-list">
				<li><strong>One global rule only.</strong> This page controls a single store-wide BOGO promotion.</li>
				<li><strong>Auto-applied.</strong> Customers don’t need a coupon — it runs in the cart.</li>
				<li><strong>Scope aware.</strong> Limit to categories or products if you don’t want it on everything.</li>
				<li><strong>Stacking.</strong> If you use other discounts, always test carts to make sure the math feels right.</li>
			</ul>
			<p class="gt-bogo-muted">
				Want multiple rules (e.g. different BOGOs per category, free gifts, cheapest item logic)?
				<strong>GT BOGO Engine PRO</strong> unlocks advanced rule sets, scheduling and more.
			</p>
		</div>

	</div><!-- .gt-bogo-grid -->

</div>

<script>
(function() {
	const scopeSelect = document.getElementById('gt_bogo_scope');
	if (!scopeSelect) return;

	function refreshScopeFields() {
		const value = scopeSelect.value;
		const cats = document.querySelector('.gt-bogo-scope-categories');
		const prods = document.querySelector('.gt-bogo-scope-products');

		if (cats) cats.style.display = (value === 'categories') ? '' : 'none';
		if (prods) prods.style.display = (value === 'products') ? '' : 'none';
	}

	scopeSelect.addEventListener('change', refreshScopeFields);
	refreshScopeFields();
})();
</script>

