<?php
/**
 * PRO Rules page (marketing + future UI) for GT BOGO Engine.
 *
 * @package GT_BOGO_Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="wrap gt-bogo-wrap gt-bogo-page-pro-rules">

	<div class="gt-bogo-header">
		<h1 class="gt-bogo-title">Advanced BOGO Rules (PRO)</h1>
		<p class="gt-bogo-subtitle">
			Design the same kind of layered promotions big retailers use: free items, cheapest item discounts, stacked category logic, schedule windows and more.
		</p>
	</div>

	<div class="gt-bogo-grid">

		<div class="gt-bogo-card xlarge">
			<h2 class="gt-bogo-card-title">What GT BOGO Engine PRO unlocks</h2>

			<div class="gt-bogo-pro-grid">
				<div class="gt-bogo-pro-feature">
					<h3>Multiple rules per store</h3>
					<p>Create separate BOGO campaigns for different categories, collections or customer groups without conflicts.</p>
				</div>
				<div class="gt-bogo-pro-feature">
					<h3>Free item campaigns</h3>
					<p>Run offers like “Buy 2 Hoodies, Get a Beanie Free” or “Buy Any 3 Tees, Get 1 Free”.</p>
				</div>
				<div class="gt-bogo-pro-feature">
					<h3>Cheapest / most expensive item logic</h3>
					<p>Classic offers like “Buy 3, get the cheapest item 100% off” or “Buy 4, get the most expensive item 50% off”.</p>
				</div>
				<div class="gt-bogo-pro-feature">
					<h3>Schedules & campaign windows</h3>
					<p>Start and end dates, weekend-only deals, seasonal campaigns — all pre-programmed.</p>
				</div>
				<div class="gt-bogo-pro-feature">
					<h3>Cart conditions & targeting</h3>
					<p>Minimum cart totals, user roles, logged-in customers, first-order-only promos, and more.</p>
				</div>
				<div class="gt-bogo-pro-feature">
					<h3>Premium support</h3>
					<p>Direct support from the creator of GRAPHIC T-SHIRTS — a WooCommerce brand running real campaigns.</p>
				</div>
			</div>

			<div class="gt-bogo-pro-cta">
				<a href="https://graphictshirts.shop/landing/gt-bogo-engine" target="_blank" rel="noopener noreferrer" class="button button-primary button-hero">
					Learn more about GT BOGO Engine PRO
				</a>
				<p class="gt-bogo-muted">
					You can safely run the free global rule without PRO. When you’re ready, PRO installs as a simple extension and
					extends this interface with a full rule builder.
				</p>
			</div>
		</div>

		<!-- Placeholders for future rule list / UI -->
		<div class="gt-bogo-card medium">
			<h2 class="gt-bogo-card-title">Future: Rule list & builder</h2>
			<p>
				This area is reserved for a visual rule builder once you’re ready to ship GT BOGO Engine PRO.
				It can show:
			</p>
			<ul class="gt-bogo-help-list">
				<li>A list of all active rules with status badges.</li>
				<li>“Add New Rule” wizard with step-by-step setup.</li>
				<li>Per-rule targeting, scheduling and preview.</li>
			</ul>
			<p class="gt-bogo-muted">
				For the WordPress.org repository, this free version focuses on the global rule while clearly showing the upgrade path.
			</p>
		</div>

	</div>

</div>

