<?php
/**
 * System Status page for GT BOGO Engine.
 *
 * @package GT_BOGO_Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $wpdb;

$php_version    = phpversion();
$wp_version     = get_bloginfo( 'version' );
$wc_version     = defined( 'WC_VERSION' ) ? WC_VERSION : 'Not detected';
$plugin_version = defined( 'GT_BOGO_ENGINE_VERSION' ) ? GT_BOGO_ENGINE_VERSION : 'Unknown';
$home_url       = home_url();
$site_url       = site_url();
$memory_limit   = ini_get( 'memory_limit' );
$debug_mode     = ( defined( 'WP_DEBUG' ) && WP_DEBUG ) ? 'Enabled' : 'Disabled';

?>
<div class="wrap gt-bogo-wrap gt-bogo-page-status">

	<div class="gt-bogo-header">
		<h1 class="gt-bogo-title">GT BOGO Engine – System Status</h1>
		<p class="gt-bogo-subtitle">
			Quick overview of your WordPress, WooCommerce and server environment. Useful for debugging and support.
		</p>
	</div>

	<div class="gt-bogo-grid">

		<div class="gt-bogo-card large">
			<h2 class="gt-bogo-card-title">Environment</h2>
			<table class="widefat striped">
				<tbody>
				<tr>
					<th scope="row">Plugin version</th>
					<td><?php echo esc_html( $plugin_version ); ?></td>
				</tr>
				<tr>
					<th scope="row">WordPress version</th>
					<td><?php echo esc_html( $wp_version ); ?></td>
				</tr>
				<tr>
					<th scope="row">WooCommerce version</th>
					<td><?php echo esc_html( $wc_version ); ?></td>
				</tr>
				<tr>
					<th scope="row">PHP version</th>
					<td><?php echo esc_html( $php_version ); ?></td>
				</tr>
				<tr>
					<th scope="row">PHP memory limit</th>
					<td><?php echo esc_html( $memory_limit ); ?></td>
				</tr>
				<tr>
					<th scope="row">WP_DEBUG</th>
					<td><?php echo esc_html( $debug_mode ); ?></td>
				</tr>
				<tr>
					<th scope="row">Home URL</th>
					<td><?php echo esc_html( $home_url ); ?></td>
				</tr>
				<tr>
					<th scope="row">Site URL</th>
					<td><?php echo esc_html( $site_url ); ?></td>
				</tr>
				<tr>
					<th scope="row">Database</th>
					<td>
						<?php echo esc_html( $wpdb->db_version() ); ?>
						(<?php echo esc_html( $wpdb->db_server_info() ); ?>)
					</td>
				</tr>
				</tbody>
			</table>
		</div>

		<div class="gt-bogo-card large">
			<h2 class="gt-bogo-card-title">WooCommerce / GT BOGO checks</h2>
			<table class="widefat striped">
				<tbody>
				<tr>
					<th scope="row">WooCommerce active</th>
					<td>
						<?php if ( class_exists( 'WooCommerce' ) ) : ?>
							<span class="status-ok">Yes</span>
						<?php else : ?>
							<span class="status-error">No – GT BOGO Engine requires WooCommerce.</span>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<th scope="row">Cart session support</th>
					<td>
						<?php if ( function_exists( 'WC' ) ) : ?>
							<span class="status-ok">WC() helper available</span>
						<?php else : ?>
							<span class="status-neutral">WC() helper not available (probably fine if WooCommerce loads normally).</span>
						<?php endif; ?>
					</td>
				</tr>
				<tr>
					<th scope="row">Theme compatibility</th>
					<td>
						GT BOGO Engine hooks into standard WooCommerce cart/checkout flows.
						If your theme customizes these heavily, always test promotions end-to-end.
					</td>
				</tr>
				<tr>
					<th scope="row">Logging</th>
					<td>
						You can enable WooCommerce logs under <strong>WooCommerce → Status → Logs</strong>
						to track discount behavior during complex campaigns.
					</td>
				</tr>
				</tbody>
			</table>
		</div>

	</div>

	<div class="gt-bogo-footer">
		<p class="gt-bogo-muted">
			If you need help, include a screenshot of this page when contacting support at
			<a href="mailto:support@graphictshirts.shop">support@graphictshirts.shop</a>.
		</p>
	</div>

</div>





