<?php
/**
 * GT BOGO Engine – Internal Documentation Page
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$pro_url = 'https://graphictshirts.shop/bogo-pro';
$support_url = 'mailto:support@graphictshirts.shop';

?>
<div class="gtbe-docs-wrap">

    <div class="gtbe-docs-header">
        <img src="<?php echo esc_url( GT_BOGO_ENGINE_URL . 'assets/img/logo-256.png' ); ?>" 
             class="gtbe-docs-logo" 
             alt="GT BOGO Engine">
        <h1>GT BOGO Engine Documentation</h1>
        <p class="gtbe-docs-tagline">
            Learn how to create powerful Buy X Get Y promotions for WooCommerce.
        </p>
    </div>

    <div class="gtbe-docs-content">

        <h2 id="getting-started">1. Getting Started</h2>
        <p>
            GT BOGO Engine is a smart discount system that lets you create offers such as:
        </p>
        <ul>
            <li>Buy 1 Get 1 Free</li>
            <li>Buy 2 Get 1 at 50% Off</li>
            <li>Buy X from Category A → Get Y from Category B</li>
            <li>Buy any product → Get cheapest item discounted</li>
            <li>And more with PRO rules</li>
        </ul>

        <p>
            After activating the plugin, visit:
            <strong>WooCommerce → GT BOGO Engine</strong>
            to configure your offers.
        </p>

        <hr>

        <h2 id="tabs">2. Understanding the GT BOGO Engine Tabs</h2>

        <h3>Settings</h3>
        <p>
            Toggle the engine on/off, enable debug mode, and manage advanced behavior.
        </p>

        <h3>Free Core Rule</h3>
        <p>
            This is your globally available Buy X Get Y offer. The free version includes:
        </p>
        <ul>
            <li>Buy quantity</li>
            <li>Get quantity</li>
            <li>Discount type</li>
            <li>Percentage or fixed discount</li>
            <li>Global or category/product scope</li>
        </ul>

        <h3>PRO Rules</h3>
        <p>
            PRO allows **unlimited rules**. You can build:
        </p>
        <ul>
            <li>Category → Category deals</li>
            <li>Brand-specific BOGO</li>
            <li>Cart-based offers (Spend X → Get Y)</li>
            <li>Mix-and-match bundles</li>
            <li>Advanced discount filters</li>
            <li>Stacked rules / priority rules</li>
        </ul>

        <a href="<?php echo esc_url($pro_url); ?>" 
           class="gtbe-docs-pro-btn" 
           target="_blank">
            Upgrade to GT BOGO PRO →
        </a>

        <hr>

        <h2 id="examples">3. Example Promotions</h2>

        <h3>Buy 1 Get 1 Free</h3>
        <pre class="gtbe-code">Buy Qty = 1
Get Qty = 1
Discount = 100% 
Scope = Global</pre>

        <h3>Buy 2 Get 1 at 50% Off</h3>
        <pre class="gtbe-code">Buy Qty = 2
Get Qty = 1
Discount = 50%
Scope = Global</pre>

        <h3>Buy from Category “Hoodies” → Get a T-Shirt 100% Off</h3>
        <pre class="gtbe-code">Buy Category = Hoodies
Get Category = T-Shirts
Get Qty = 1
Discount = 100%
Scope = Category → Category</pre>

        <hr>

        <h2 id="faq">4. Frequently Asked Questions</h2>

        <h3>Do discounts stack?</h3>
        <p>
            Yes — the engine applies multiple rules unless you set priorities in PRO.
        </p>

        <h3>Does it support variable products?</h3>
        <p>
            Yes — variations are supported like regular products.
        </p>

        <h3>Does it work with coupons?</h3>
        <p>
            Yes. You may choose to disable coupon stacking in PRO settings.
        </p>

        <h3>Does it support multicurrency?</h3>
        <p>
            Yes — works with most popular multicurrency plugins.
        </p>

        <hr>

        <h2 id="import-export">5. Importing &amp; Exporting Rules (PRO)</h2>
<p>
  <strong>PRO feature:</strong> Import/Export is available only to stores with an active 1-year PRO subscription.
  If you do not have a valid PRO license, the Import/Export screen will not be accessible.
</p>

<div class="gtb-card">
  <h3>Exporting rules</h3>
  <ol>
    <li>Go to <strong>GT BOGO ENGINE → Import/Export</strong>.</li>
    <li>Click <strong>Export Rules</strong>.</li>
    <li>A <code>.json</code> file will download to your computer. Keep it as a backup or move it to another site.</li>
  </ol>
</div>

<div class="gtb-card">
  <h3>Importing rules (uploading a JSON file)</h3>
  <p>
    Imports are intended for PRO users who purchased the 1-year subscription and want to restore rules from a backup
    or load a PRO rule pack (exported JSON).
  </p>
  <ol>
    <li>Confirm your PRO license is active.</li>
    <li>Go to <strong>GT BOGO ENGINE → Import/Export</strong>.</li>
    <li>Under <strong>Import Rules</strong>, click <strong>Choose File</strong> and select your exported <code>.json</code> file.</li>
    <li>Click <strong>Import Rules</strong>.</li>
    <li>After import, review your rules and test the cart to confirm the promotions apply as expected.</li>
  </ol>

  <p class="gtb-muted">
    Safety notes: Only import JSON files generated by GT BOGO ENGINE. Importing unknown files can overwrite existing
    rules and may produce unexpected discounts. Always export a backup before importing new rule sets.
  </p>
</div>


<h2 id="support">6. Support</h2>
        <p>
            Get help by contacting:
            <a href="<?php echo esc_attr($support_url); ?>">support@graphictshirts.shop</a>
        </p>

        <p>Premium support is available with GT BOGO PRO.</p>
        <a href="<?php echo esc_url($pro_url); ?>" 
           class="gtbe-docs-pro-btn" 
           target="_blank">
            Upgrade to PRO →
        </a>

    </div>
</div>

<style>
.gtbe-docs-wrap {
    max-width: 900px;
    margin: 40px auto;
    background: #ffffff;
    padding: 40px 50px;
    border-radius: 14px;
    box-shadow: 0 12px 40px rgba(0,0,0,0.08);
    font-family: "Inter", sans-serif;
}

.gtbe-docs-header {
    text-align: center;
    margin-bottom: 40px;
}

.gtbe-docs-logo {
    width: 100px;
    margin-bottom: 20px;
}

.gtbe-docs-tagline {
    font-size: 16px;
    color: #777;
}

.gtbe-docs-content h2 {
    margin-top: 45px;
    border-left: 5px solid #0071FF;
    padding-left: 15px;
}

.gtbe-docs-content h3 {
    margin-top: 30px;
    color: #333;
}

.gtbe-code {
    background: #272822;
    color: #fff;
    padding: 15px;
    border-radius: 8px;
    font-family: Consolas, monospace;
    margin-top: 10px;
}

.gtbe-docs-pro-btn {
    display: inline-block;
    padding: 12px 22px;
    margin-top: 20px;
    background: #0071FF;
    color: #fff;
    text-decoration: none;
    border-radius: 6px;
    font-weight: 600;
}

.gtbe-docs-pro-btn:hover {
    background: #005ad1;
}
</style>
