<?php
/**
 * GT BOGO Engine – Documentation Page
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

?>

<div class="gtbe-docs-wrap gtbe-card">

    <div class="gtbe-docs-header">
        <h2 class="gtbe-docs-title">GT BOGO Engine Documentation</h2>
        <p class="gtbe-docs-subtitle">
            Learn how to create Buy X Get Y promotions, free-item rules, cheapest item discounts, 
            category targeting and schedule-based deals — all without coupon codes.
        </p>
    </div>

    <!-- QUICK NAV -->
    <div class="gtbe-docs-nav">
        <a href="#core" class="gtbe-docs-nav-link">Core Concepts</a>
        <a href="#free-rule" class="gtbe-docs-nav-link">Free Rule</a>
        <a href="#pro-rules" class="gtbe-docs-nav-link">PRO Rules</a>
        <a href="#targeting" class="gtbe-docs-nav-link">Targeting</a>
        <a href="#scheduling" class="gtbe-docs-nav-link">Scheduling</a>
        <a href="#cart" class="gtbe-docs-nav-link">Cart Behavior</a>
        <a href="#faq" class="gtbe-docs-nav-link">FAQ</a>
        <a href="#support" class="gtbe-docs-nav-link">Support</a>
    </div>

    <!-- SECTION: Core Concepts -->
    <div id="core" class="gtbe-docs-section">
        <h3 class="gtbe-docs-section-title">Core Concepts</h3>
        <p>
            GT BOGO Engine is a rule-based discount engine designed for WooCommerce stores
            that want simple or advanced Buy X Get Y promotions without needing to rely on coupon codes.
        </p>

        <ul class="gtbe-docs-list">
            <li><strong>Buy Quantity</strong> — how many items must be purchased.</li>
            <li><strong>Get Quantity</strong> — how many items are discounted or free.</li>
            <li><strong>Discount Type</strong> — percentage or fixed price.</li>
            <li><strong>Scope</strong> — global, category-specific, or product-specific.</li>
            <li><strong>PRO Rules</strong> — allows unlimited custom rules and advanced logic.</li>
        </ul>
    </div>

    <!-- SECTION: Free Rule -->
    <div id="free-rule" class="gtbe-docs-section">
        <h3 class="gtbe-docs-section-title">Free Core Rule</h3>
        <p>
            The free version includes one global rule: <strong>Buy 1 Get 1 at 50% Off</strong>.  
            This rule is great for:
        </p>
        <ul class="gtbe-docs-list">
            <li>Store-wide BOGO promotions</li>
            <li>Testing your setup</li>
            <li>A general incentive to increase AOV (average order value)</li>
        </ul>
        <p>
            You can change the buy quantity, get quantity, or discount amount — but only for one rule.
        </p>
    </div>

    <!-- SECTION: PRO Rules -->
    <div id="pro-rules" class="gtbe-docs-section">
        <h3 class="gtbe-docs-section-title">PRO Rules</h3>
        <p>
            Upgrading to PRO unlocks:
        </p>

        <ul class="gtbe-docs-list">
            <li>Create unlimited BOGO rules</li>
            <li>Free item rules (Buy 2 Get 1 Free)</li>
            <li>Cheapest item discounts (Buy 3, Cheapest 40% Off)</li>
            <li>Category-only rules</li>
            <li>Product-specific rules</li>
            <li>Scheduling start/end dates</li>
            <li>User role targeting</li>
            <li>Cart subtotal minimums</li>
        </ul>

        <p>
            PRO rules are stacked, prioritized, and optimized to avoid conflicts in the cart.

        <div class="gtbe-docs-card">
            <h4 class="gtbe-docs-card-title">Import / Export PRO Rules (JSON)</h4>
            <p class="gtbe-docs-card-text">
                PRO includes the <strong>Import / Export</strong> tool so you can back up rules, move campaigns between stores,
                or restore your configuration after a migration. Exported rules are saved as <strong>.json</strong> files.
            </p>
            <ol class="gtbe-docs-steps">
                <li><strong>Open:</strong> <em>GT BOGO ENGINE → Import / Export</em>.</li>
                <li><strong>Export:</strong> Click <em>Export Rules (JSON)</em> to download a backup file.</li>
                <li><strong>Import:</strong> Click <em>Choose File</em>, select a previously exported <em>.json</em> rule file, then click <em>Import</em>.</li>
                <li><strong>Verify:</strong> Go to <em>PRO Rules</em> and confirm your rules and priorities are correct.</li>
            </ol>
            <p class="gtbe-docs-card-text"><strong>Important:</strong> Import/Export is <strong>PRO-only</strong> and requires an active 1-year subscription license.</p>
        </div>

        </p>
    </div>

    <!-- SECTION: Targeting -->
    <div id="targeting" class="gtbe-docs-section">
        <h3 class="gtbe-docs-section-title">Targeting & Filters</h3>
        <p>
            You can target rules to:
        </p>

        <ul class="gtbe-docs-list">
            <li>Specific product categories</li>
            <li>Specific individual products</li>
            <li>Exclude categories or products</li>
            <li>Apply rules to sale items or exclude them</li>
        </ul>

        <p>
            Targeting ensures your rules only fire where they are supposed to.
        </p>
    </div>

    <!-- SECTION: Scheduling -->
    <div id="scheduling" class="gtbe-docs-section">
        <h3 class="gtbe-docs-section-title">Scheduling Rules</h3>
        <p>
            Each PRO rule allows:
        </p>

        <ul class="gtbe-docs-list">
            <li><strong>Start Date & Time</strong></li>
            <li><strong>End Date & Time</strong></li>
        </ul>

        <p>
            Great for:
        </p>

        <ul class="gtbe-docs-list">
            <li>Holiday sales</li>
            <li>Weekend-only promotions</li>
            <li>Flash sales</li>
            <li>Synchronized marketing campaigns</li>
        </ul>
    </div>

    <!-- SECTION: Cart -->
    <div id="cart" class="gtbe-docs-section">
        <h3 class="gtbe-docs-section-title">Cart Behavior</h3>
        <p>
            GT BOGO Engine automatically:
        </p>

        <ul class="gtbe-docs-list">
            <li>Detects qualifying items</li>
            <li>Calculates discounts accurately</li>
            <li>Labels them clearly in the cart & checkout</li>
            <li>Avoids double-discounting or coupon conflicts</li>
            <li>Applies discounts per-line, not per-cart, for transparency</li>
        </ul>
    </div>

    <!-- SECTION: FAQ -->
    <div id="faq" class="gtbe-docs-section">
        <h3 class="gtbe-docs-section-title">FAQ</h3>
        <div class="gtbe-faq-item">
            <strong>Does it work with variable products?</strong>
            <p>Yes — variations are supported and counted individually.</p>
        </div>

        <div class="gtbe-faq-item">
            <strong>Do PRO rules stack?</strong>
            <p>Yes, if configured — or you can block stacking via priorities.</p>
        </div>

        <div class="gtbe-faq-item">
            <strong>Are discounts compatible with coupons?</strong>
            <p>Yes, as long as coupons do not conflict with BOGO matching logic.</p>
        </div>

        <div class="gtbe-faq-item">
            <strong>Does it work with membership pricing?</strong>
            <p>Yes. Membership plugins do not interfere with BOGO rules.</p>
        </div>

        <div class="gtbe-faq-item">
            <strong>Are PRO discounts applied automatically?</strong>
            <p>Yes. No coupons are needed for customers.</p>
        </div>
    </div>

    <!-- SECTION: Support -->
    <div id="support" class="gtbe-docs-section">
        <h3 class="gtbe-docs-section-title">Support & Contact</h3>
        <p>
            Need help? We’re here for you.
        </p>

        <ul class="gtbe-docs-list">
            <li><a href="mailto:support@graphictshirts.shop">Email: support@graphictshirts.shop</a></li>
            <li><a href="https://graphictshirts.shop/bogo" target="_blank">Plugin Sales Page ↗</a></li>
            <li><a href="https://graphictshirts.shop" target="_blank">GRAPHIC T-SHIRTS Homepage</a></li>
        </ul>

        <p class="gtbe-docs-footer">
            Thank you for supporting an independent creator.  
            GT BOGO Engine is built with pride by GRAPHIC T-SHIRTS.
        </p>
    </div>
</div>
