<?php
/**
 * GT BOGO Engine – Import / Export Rules
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

// Load saved rule sets
$free_rule  = get_option('gt_bogo_engine_free_rule', array());
$pro_rules  = get_option('gt_bogo_engine_rules', array());
?>

<div class="gtbe-import-export-wrap gtbe-card">

    <h2 class="gtbe-page-title">Import / Export Rules</h2>
    <p class="gtbe-page-subtitle">
        Export or import your GT BOGO Engine rules for backup, migration, or testing across different websites.
    </p>

    <!-- EXPORT SECTION -->
    <div class="gtbe-section">
        <h3 class="gtbe-section-title">Export Rules</h3>
        <p>Download your rules as a JSON file.</p>

        <div class="gtbe-export-buttons">

            <!-- EXPORT ALL -->
            <form method="post">
                <?php wp_nonce_field('gtbe_export_all'); ?>
                <input type="hidden" name="gtbe_export_action" value="all">
                <button class="button button-primary gtbe-btn-lg">
                    Export All Rules (Free + PRO)
                </button>
            </form>

            <!-- EXPORT PRO ONLY -->
            <form method="post">
                <?php wp_nonce_field('gtbe_export_pro'); ?>
                <input type="hidden" name="gtbe_export_action" value="pro">
                <button class="button gtbe-btn-lg">
                    Export PRO Rules Only
                </button>
            </form>
        </div>
    </div>

    <hr class="gtbe-divider">

    <!-- IMPORT SECTION -->
    <div class="gtbe-section">
        <h3 class="gtbe-section-title">Import Rules</h3>

        <p>
            Choose a JSON file generated by GT BOGO Engine.  
            You can choose to merge rules or overwrite all existing rules.
        </p>

        <form method="post" enctype="multipart/form-data" class="gtbe-import-form">
            <?php wp_nonce_field('gtbe_import_rules'); ?>

            <input type="file" name="gtbe_import_file" accept=".json" required>

            <label class="gtbe-import-mode">
                <input type="radio" name="gtbe_import_mode" value="merge" checked>
                Merge with existing rules
            </label>

            <label class="gtbe-import-mode">
                <input type="radio" name="gtbe_import_mode" value="overwrite">
                Overwrite all existing rules
            </label>

            <button class="button button-primary gtbe-btn-lg" type="submit">
                Import Rules
            </button>
        </form>
    </div>
</div>
