<?php
/**
 * GT BOGO Engine – Welcome Wizard / Onboarding Card
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$current_tab = isset( $_GET['tab'] ) ? sanitize_key( $_GET['tab'] ) : 'settings';

// Helper URLs for tabs.
$base_url      = admin_url( 'admin.php?page=gt-bogo-engine' );
$url_settings  = $base_url . '&tab=settings';
$url_free_rule = $base_url . '&tab=free_rule';
$url_pro_rules = $base_url . '&tab=pro_rules';
$url_docs      = $base_url . '&tab=documentation';
?>

<div class="gtbe-welcome-wrap gtbe-card">

    <div class="gtbe-welcome-header">
        <div class="gtbe-welcome-title-block">
            <div class="gtbe-badge gtbe-badge-soft">Welcome to</div>
            <h2 class="gtbe-welcome-title">
                GT BOGO Engine for WooCommerce
            </h2>
            <p class="gtbe-welcome-subtitle">
                A clean Buy X Get Y (BOGO) rules engine built by
                <strong>GRAPHIC T-SHIRTS</strong> to help you run real retail-grade promotions
                without coupon chaos.
            </p>
        </div>

        <div class="gtbe-welcome-meta">
            <div class="gtbe-welcome-kv">
                <span class="gtbe-welcome-kv-label"><?php esc_html_e( 'Version', 'gt-bogo-engine' ); ?></span>
                <span class="gtbe-welcome-kv-value"><?php echo esc_html( GT_BOGO_ENGINE_VERSION ); ?></span>
            </div>
            <div class="gtbe-welcome-kv">
                <span class="gtbe-welcome-kv-label"><?php esc_html_e( 'Status', 'gt-bogo-engine' ); ?></span>
                <span class="gtbe-welcome-kv-value">
                    <?php esc_html_e( 'Engine Ready', 'gt-bogo-engine' ); ?>
                </span>
            </div>
            <div class="gtbe-welcome-kv">
                <span class="gtbe-welcome-kv-label"><?php esc_html_e( 'Brand', 'gt-bogo-engine' ); ?></span>
                <span class="gtbe-welcome-kv-value">
                    <a href="https://graphictshirts.shop" target="_blank" rel="noopener noreferrer">
                        GRAPHIC T-SHIRTS ↗
                    </a>
                </span>
            </div>
        </div>
    </div>

    <div class="gtbe-welcome-steps">
        <div class="gtbe-w-step">
            <div class="gtbe-w-step-number">1</div>
            <h3><?php esc_html_e( 'Enable the engine & basics', 'gt-bogo-engine' ); ?></h3>
            <p>
                Turn the engine on and set debug / rounding behavior so discounts look
                clean in the cart and checkout.
            </p>
            <a class="button button-secondary" href="<?php echo esc_url( $url_settings ); ?>">
                <?php esc_html_e( 'Go to Settings', 'gt-bogo-engine' ); ?>
            </a>
        </div>

        <div class="gtbe-w-step">
            <div class="gtbe-w-step-number">2</div>
            <h3><?php esc_html_e( 'Configure the free global rule', 'gt-bogo-engine' ); ?></h3>
            <p>
                Use the free “Buy 1 Get 1 at 50% Off” rule to test your setup and run a
                simple store-wide BOGO in minutes.
            </p>
            <a class="button button-secondary" href="<?php echo esc_url( $url_free_rule ); ?>">
                <?php esc_html_e( 'Free Rule Setup', 'gt-bogo-engine' ); ?>
            </a>
        </div>

        <div class="gtbe-w-step">
            <div class="gtbe-w-step-number">3</div>
            <h3><?php esc_html_e( 'Add PRO rules for real campaigns', 'gt-bogo-engine' ); ?></h3>
            <p>
                Create multiple targeted rules: free items, cheapest item discounts,
                category-only promos and scheduled offers.
            </p>
            <a class="button button-primary" href="<?php echo esc_url( $url_pro_rules ); ?>">
                <?php esc_html_e( 'Create PRO Rules', 'gt-bogo-engine' ); ?>
            </a>
        </div>

        <div class="gtbe-w-step">
            <div class="gtbe-w-step-number">4</div>
            <h3><?php esc_html_e( 'Test in a real cart', 'gt-bogo-engine' ); ?></h3>
            <p>
                Add matching products to your cart in a private browser window and confirm
                that discounts look transparent and fair.
            </p>
            <a class="button" href="<?php echo esc_url( home_url( '/shop/' ) ); ?>" target="_blank">
                <?php esc_html_e( 'Open Storefront', 'gt-bogo-engine' ); ?>
            </a>
        </div>
    </div>

    <div class="gtbe-welcome-footer">
        <div class="gtbe-welcome-footer-left">
            <span class="gtbe-mini-pill"><?php esc_html_e( 'Docs & Support', 'gt-bogo-engine' ); ?></span>
            <a href="<?php echo esc_url( $url_docs ); ?>">
                <?php esc_html_e( 'Read Documentation inside the plugin', 'gt-bogo-engine' ); ?>
            </a>
            <span class="gtbe-dot">•</span>
            <a href="mailto:support@graphictshirts.shop">
                <?php esc_html_e( 'Email support', 'gt-bogo-engine' ); ?>
            </a>
        </div>
        <div class="gtbe-welcome-footer-right">
            <span class="gtbe-welcome-muted">
                <?php esc_html_e( 'Thank you for supporting an independent WooCommerce creator.', 'gt-bogo-engine' ); ?>
            </span>
        </div>
    </div>
</div>

