<?php
/**
 * Upsell modal for GT BOGO PRO
 *
 * @package GT_BOGO_Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div id="gt-bogo-upsell-overlay" class="gt-bogo-upsell-overlay" aria-hidden="true">
    <div class="gt-bogo-upsell-backdrop"></div>

    <div class="gt-bogo-upsell-modal" role="dialog" aria-modal="true" aria-labelledby="gt-bogo-upsell-title">
        <button type="button" class="gt-bogo-upsell-close" aria-label="<?php esc_attr_e( 'Close', 'gt-bogo-engine' ); ?>">
            <span class="gt-bogo-upsell-close-icon">&times;</span>
        </button>

        <header class="gt-bogo-upsell-header">
            <div class="gt-bogo-upsell-badge">
                <span class="gt-bogo-upsell-badge-label">
                    <?php esc_html_e( 'PRO Upgrade', 'gt-bogo-engine' ); ?>
                </span>
                <span class="gt-bogo-upsell-badge-pill">
                    <?php esc_html_e( 'Boost your WooCommerce revenue', 'gt-bogo-engine' ); ?>
                </span>
            </div>

            <h2 id="gt-bogo-upsell-title" class="gt-bogo-upsell-title">
                <?php esc_html_e( 'Unlock GT BOGO Engine PRO', 'gt-bogo-engine' ); ?>
            </h2>

            <p class="gt-bogo-upsell-subtitle">
                <?php esc_html_e( 'Turn simple “Buy 1 Get 1 at 50% Off” into a full promotion engine with advanced rules, targeting, and scheduling — without touching code.', 'gt-bogo-engine' ); ?>
            </p>
        </header>

        <section class="gt-bogo-upsell-body">
            <div class="gt-bogo-upsell-columns">
                <div class="gt-bogo-upsell-column gt-bogo-upsell-column-main">
                    <h3 class="gt-bogo-upsell-section-title">
                        <?php esc_html_e( 'Everything in FREE, plus:', 'gt-bogo-engine' ); ?>
                    </h3>

                    <ul class="gt-bogo-upsell-list">
                        <li>
                            <span class="gt-bogo-upsell-check">✓</span>
                            <span>
                                <strong><?php esc_html_e( 'Multiple PRO BOGO rules', 'gt-bogo-engine' ); ?></strong>
                                <br>
                                <?php esc_html_e( 'Run several campaigns at once: storewide promos, category promos, and special offers for key products.', 'gt-bogo-engine' ); ?>
                            </span>
                        </li>

                        <li>
                            <span class="gt-bogo-upsell-check">✓</span>
                            <span>
                                <strong><?php esc_html_e( 'Free item promos (Buy X Get Y Free)', 'gt-bogo-engine' ); ?></strong>
                                <br>
                                <?php esc_html_e( '“Buy 2 Get 1 Free”, “Buy 3 Get 2 Free”, and more – ideal for clearing stock without coupon codes.', 'gt-bogo-engine' ); ?>
                            </span>
                        </li>

                        <li>
                            <span class="gt-bogo-upsell-check">✓</span>
                            <span>
                                <strong><?php esc_html_e( 'Cheapest item discounts', 'gt-bogo-engine' ); ?></strong>
                                <br>
                                <?php esc_html_e( 'Classic retail behavior: “Buy 3, get the cheapest item 40% off” or similar smart cart logic.', 'gt-bogo-engine' ); ?>
                            </span>
                        </li>

                        <li>
                            <span class="gt-bogo-upsell-check">✓</span>
                            <span>
                                <strong><?php esc_html_e( 'Category & product targeting', 'gt-bogo-engine' ); ?></strong>
                                <br>
                                <?php esc_html_e( 'Limit offers to specific categories or products, so you only discount what you actually want to move.', 'gt-bogo-engine' ); ?>
                            </span>
                        </li>

                        <li>
                            <span class="gt-bogo-upsell-check">✓</span>
                            <span>
                                <strong><?php esc_html_e( 'Schedule & conditions', 'gt-bogo-engine' ); ?></strong>
                                <br>
                                <?php esc_html_e( 'Run weekend-only offers, seasonal sales, or promos for logged-in customers with minimum cart totals.', 'gt-bogo-engine' ); ?>
                            </span>
                        </li>

                        <li>
                            <span class="gt-bogo-upsell-check">✓</span>
                            <span>
                                <strong><?php esc_html_e( 'Priority support from the creator', 'gt-bogo-engine' ); ?></strong>
                                <br>
                                <?php esc_html_e( 'Talk directly to the indie creator behind GRAPHIC T-SHIRTS and GT BOGO Engine when you need help.', 'gt-bogo-engine' ); ?>
                            </span>
                        </li>
                    </ul>
                </div>

                <aside class="gt-bogo-upsell-column gt-bogo-upsell-column-side">
                    <div class="gt-bogo-upsell-pricing">
                        <div class="gt-bogo-upsell-price-label">
                            <?php esc_html_e( 'Special indie creator pricing', 'gt-bogo-engine' ); ?>
                        </div>
                        <div class="gt-bogo-upsell-price-row">
                            <span class="gt-bogo-upsell-price-amount">$19.99</span>
                            <span class="gt-bogo-upsell-price-meta">
                                <?php esc_html_e( '/ year · per site', 'gt-bogo-engine' ); ?>
                            </span>
                        </div>
                        <p class="gt-bogo-upsell-price-note">
                            <?php esc_html_e( 'One small yearly license. PRO features stay active as long as your license is valid.', 'gt-bogo-engine' ); ?>
                        </p>

                        <a href="https://graphictshirts.shop/bogo" target="_blank" rel="noopener noreferrer" class="gt-bogo-upsell-cta-primary">
                            <?php esc_html_e( 'Upgrade to GT BOGO Engine PRO', 'gt-bogo-engine' ); ?>
                            <span class="gt-bogo-upsell-cta-arrow">↗</span>
                        </a>

                        <button type="button" class="gt-bogo-upsell-cta-secondary gt-bogo-upsell-close-btn">
                            <?php esc_html_e( 'Keep using the free version', 'gt-bogo-engine' ); ?>
                        </button>

                        <div class="gt-bogo-upsell-footnote">
                            <?php esc_html_e( 'You can upgrade later at any time – your existing settings stay intact.', 'gt-bogo-engine' ); ?>
                        </div>
                    </div>

                    <div class="gt-bogo-upsell-meta">
                        <h4><?php esc_html_e( 'Designed by a real WooCommerce brand', 'gt-bogo-engine' ); ?></h4>
                        <p>
                            <?php esc_html_e( 'GT BOGO Engine is built by GRAPHIC T-SHIRTS, an independent premium streetwear label running WooCommerce at scale. This is battle-tested in a real store, not a lab.', 'gt-bogo-engine' ); ?>
                        </p>
                    </div>
                </aside>
            </div>
        </section>

        <footer class="gt-bogo-upsell-footer">
            <a href="https://graphictshirts.shop/bogo" target="_blank" rel="noopener noreferrer">
                <?php esc_html_e( 'View full feature comparison on graphictshirts.shop/bogo', 'gt-bogo-engine' ); ?>
            </a>
        </footer>
    </div>
</div>
