<?php
/**
 * GT BOGO Engine – Welcome Wizard
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$plugin_url = admin_url('admin.php?page=gt-bogo-engine');
$docs_url   = 'https://graphictshirts.shop/bogo-docs';
$pro_url    = 'https://graphictshirts.shop/bogo-pro';

?>
<div class="gtbe-wizard-wrap">

    <div class="gtbe-wizard-header">
        <img src="<?php echo esc_url( 'https://graphictshirts.shop/bogo/icon-512x512.png' ); ?>" 
             alt="GT BOGO Engine Logo"
             class="gtbe-wizard-logo">
        <h1>Welcome to GT BOGO ENGINE</h1>
        <p class="gtbe-wizard-subtitle">
            Thank you for installing the #1 Buy X Get Y discount engine for WooCommerce.
            Let’s configure your first offer in under 30 seconds.
        </p>
    </div>

    <div class="gtbe-wizard-steps">

        <div class="gtbe-wizard-step active">
            <h2>1. Enable the Engine</h2>
            <p>Turn on GT BOGO Engine so it activates inside your store.</p>
            <a href="<?php echo esc_url( $plugin_url . '&tab=settings' ); ?>" 
               class="button-primary gtbe-wizard-btn">
                Go to Settings
            </a>
        </div>

        <div class="gtbe-wizard-step">
            <h2>2. Configure Your Free BOGO Rule</h2>
            <p>Create your first Buy 1 Get 1 or Buy X Get Y discount offer.</p>
            <a href="<?php echo esc_url( $plugin_url . '&tab=free-rule' ); ?>" 
               class="button gtbe-wizard-btn">
                Set Up Free Rule
            </a>
        </div>

        <div class="gtbe-wizard-step">
            <h2>3. Add Unlimited PRO Rules</h2>
            <p>Unlock advanced rules for categories, upsells, bundles, cart logic, and more.</p>
            <a href="<?php echo esc_url( $pro_url ); ?>" 
               target="_blank"
               class="button-secondary gtbe-wizard-btn">
                Upgrade to PRO
            </a>
        </div>

        <div class="gtbe-wizard-step">
            <h2>4. Read the Documentation</h2>
            <p>Full guides, examples, support, and usage tutorials.</p>
            <a href="<?php echo esc_url( $docs_url ); ?>" 
               target="_blank"
               class="button gtbe-wizard-btn">
                View Documentation
            </a>
        </div>

    </div>

    <div class="gtbe-wizard-footer">
        <a href="<?php echo esc_url( $plugin_url ); ?>" class="gtbe-wizard-skip">
            Skip Setup → Dashboard
        </a>
    </div>

</div>

<style>
.gtbe-wizard-wrap {
    max-width: 900px;
    margin: 40px auto;
    background: #fff;
    padding: 40px;
    border-radius: 14px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.08);
    font-family: "Inter", sans-serif;
}

.gtbe-wizard-header {
    text-align: center;
    margin-bottom: 40px;
}

.gtbe-wizard-logo {
    width: 110px;
    margin-bottom: 20px;
}

.gtbe-wizard-subtitle {
    font-size: 16px;
    color: #555;
}

.gtbe-wizard-steps {
    display: grid;
    grid-template-columns: 1fr;
    gap: 30px;
}

.gtbe-wizard-step {
    padding: 25px;
    background: #f8f9fc;
    border-left: 5px solid #0071FF;
    border-radius: 10px;
}

.gtbe-wizard-step h2 {
    margin-top: 0;
    font-size: 20px;
}

.gtbe-wizard-btn {
    margin-top: 15px;
    display: inline-block;
}

.gtbe-wizard-footer {
    text-align: center;
    margin-top: 40px;
}

.gtbe-wizard-skip {
    color: #0071FF;
    font-weight: 600;
    text-decoration: none;
}
.gtbe-wizard-skip:hover {
    text-decoration: underline;
}
</style>
