<?php
/**
 * Admin View: Documentation Page
 *
 * @package GT_BOGO_Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
require_once dirname( __FILE__ ) . '/partials/brand-header.php';


?>
<div class="gt-bogo-admin-wrap gt-bogo-docs-page">

    <div class="gt-bogo-header">
        <div class="gt-bogo-header-left">
            <h1>📘 <?php esc_html_e( 'GT BOGO Engine Documentation', 'gt-bogo-engine' ); ?></h1>
            <p class="gt-bogo-subtitle">
                <?php esc_html_e( 'Learn how to configure rules, apply discounts automatically, and build high-converting BOGO campaigns.', 'gt-bogo-engine' ); ?>
            </p>
        </div>

        <div class="gt-bogo-header-right">
            <a href="https://graphictshirts.shop/bogo" target="_blank" class="gt-bogo-btn-primary">
                <?php esc_html_e( 'Plugin Sales Page', 'gt-bogo-engine' ); ?> ↗
            </a>
            <a href="mailto:support@graphictshirts.shop" class="gt-bogo-btn-secondary">
                <?php esc_html_e( 'Support', 'gt-bogo-engine' ); ?>
            </a>
        </div>
    </div>

    <div class="gt-bogo-docs-container">

        <!-- Getting Started -->
        <section class="gt-bogo-docs-section">
            <h2>🚀 <?php esc_html_e( 'Getting Started', 'gt-bogo-engine' ); ?></h2>
            <p>
                <?php esc_html_e( 'Once activated, visit WooCommerce → GT BOGO Engine to configure settings and rules. Enable the engine, then customize BOGO rules.', 'gt-bogo-engine' ); ?>
            </p>
        </section>

        <!-- Free Rule -->
        <section class="gt-bogo-docs-section">
            <h2>🎁 <?php esc_html_e( 'Free Core Rule (Buy 1 Get 1 at 50% Off)', 'gt-bogo-engine' ); ?></h2>
            <p>
                <?php esc_html_e( 'This global rule is included for free. You may customize quantities, discount type, scope, categories, and product targeting.', 'gt-bogo-engine' ); ?>
            </p>
        </section>

        <!-- PRO Rules -->
        <section class="gt-bogo-docs-section">
            <h2>💎 <?php esc_html_e( 'PRO Rules (Advanced Builder)', 'gt-bogo-engine' ); ?></h2>
            <ul>
                <li><?php esc_html_e( 'Buy X Get Y Free', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Buy X Get Y % Off', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Discount cheapest items', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Category-specific promotions', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Product-specific targeting', 'gt-bogo-engine' ); ?></li>
            </ul>
        </section>

        <!-- Cart Behaviour -->
        <section class="gt-bogo-docs-section">
            <h2>🛒 <?php esc_html_e( 'How Discounts Apply in the Cart', 'gt-bogo-engine' ); ?></h2>
            <p>
                <?php esc_html_e( 'All discounts are applied automatically — no coupons required. When a shopper meets a rule, the discount appears instantly at checkout.', 'gt-bogo-engine' ); ?>
            </p>
        </section>

        <!-- Settings -->
        <section class="gt-bogo-docs-section">
            <h2>⚙️ <?php esc_html_e( 'Engine Settings', 'gt-bogo-engine' ); ?></h2>
            <ul>
                <li><?php esc_html_e( 'Turn the BOGO engine on or off', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Enable debug mode', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Hide PRO upgrade prompts', 'gt-bogo-engine' ); ?></li>
            </ul>
        </section>

        <!-- Import Export -->
        <section class="gt-bogo-docs-section">
            <h2>📤 <?php esc_html_e( 'Import & Export Rules', 'gt-bogo-engine' ); ?></h2>
            <p>
                <?php esc_html_e( 'Easily transfer rules between stores. Export a JSON file or import rules into a new site.', 'gt-bogo-engine' ); ?>
            </p>
        </section>

        <!-- Compatibility -->
        <section class="gt-bogo-docs-section">
            <h2>🧩 <?php esc_html_e( 'Compatibility', 'gt-bogo-engine' ); ?></h2>
            <p>
                <?php esc_html_e( 'Compatible with all major WooCommerce themes (Astra, Flatsome, Salient, Storefront) and most cart/checkout plugins.', 'gt-bogo-engine' ); ?>
            </p>
        </section>

        <!-- Support -->
        <section class="gt-bogo-docs-section">
            <h2>💬 <?php esc_html_e( 'Need Help?', 'gt-bogo-engine' ); ?></h2>
            <p>
                <?php esc_html_e( 'Email support anytime:', 'gt-bogo-engine' ); ?>
                <a href="mailto:support@graphictshirts.shop">support@graphictshirts.shop</a>
            </p>
            <p>
                <?php esc_html_e( 'Plugin Homepage:', 'gt-bogo-engine' ); ?>
                <a href="https://graphictshirts.shop/bogo" target="_blank">
                    https://graphictshirts.shop/bogo
                </a>
            </p>
        </section>

    </div>
</div>
