<?php
/**
 * GT BOGO Engine – Free Core Rule Page (Premium UI)
 *
 * Location: includes/admin/views/page-free-rule.php
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
require_once dirname( __FILE__ ) . '/partials/brand-header.php';


$rule = get_option( 'gt_bogo_engine_free_rule', array(
    'enabled'        => 1,
    'title'          => 'Buy 1 Get 1 at 50% Off (Global)',
    'buy_qty'        => 1,
    'get_qty'        => 1,
    'discount_type'  => 'percent',
    'discount_value' => 50,
    'scope'          => 'global',
    'categories'     => array(),
    'products'       => array(),
) );

$settings = get_option( 'gt_bogo_engine_settings', array() );
$pro_nag_hidden = ! empty( $settings['pro_nag_hidden'] );

$base_url = admin_url( 'admin.php?page=gt-bogo-engine' );
$free_rule_url = add_query_arg( 'tab', 'free_rule', $base_url );
$settings_url = add_query_arg( 'tab', 'settings', $base_url );
$pro_rules_url = add_query_arg( 'tab', 'pro_rules', $base_url );
$import_url = add_query_arg( 'tab', 'import_export', $base_url );
$license_url = add_query_arg( 'tab', 'license', $base_url );
$welcome_url = add_query_arg( 'tab', 'welcome', $base_url );
$docs_url = add_query_arg( 'tab', 'docs', $base_url );

?>

<div class="wrap gt-bogo-engine-wrap">

    <!-- Header -->
    <div class="gt-bogo-engine-header">
        <div>
            <h1><?php esc_html_e( 'Free Core BOGO Rule', 'gt-bogo-engine' ); ?></h1>
            <p><?php esc_html_e( 'This rule is always included for free. You may edit it but not duplicate it.', 'gt-bogo-engine' ); ?></p>
        </div>
    </div>

    <!-- Tabs -->
    <nav class="gt-bogo-engine-tabs">
        <a href="<?php echo esc_url( $base_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Dashboard', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $settings_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Settings', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $free_rule_url ); ?>" class="gt-bogo-engine-tab is-active">
            <?php esc_html_e( 'Free Core Rule', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $pro_rules_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'PRO Rules', 'gt-bogo-engine' ); ?>
            <span class="gt-bogo-engine-badge gt-bogo-engine-badge-pro">PRO</span>
        </a>
        <a href="<?php echo esc_url( $import_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Import / Export', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $license_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'License', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $welcome_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Welcome', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $docs_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Docs', 'gt-bogo-engine' ); ?>
        </a>
    </nav>

    <!-- Free Rule Form -->
    <form method="post" id="gt-bogo-engine-free-rule-form" class="gt-bogo-engine-form" data-context="free_rule">

        <!-- ACTIVE -->
        <div class="gt-bogo-engine-panel">
            <h2><?php esc_html_e( 'Rule Status', 'gt-bogo-engine' ); ?></h2>

            <div class="gt-bogo-engine-field">
                <label for="free_rule_enabled">
                    <?php esc_html_e( 'Enable this rule', 'gt-bogo-engine' ); ?>
                </label>

                <label class="gt-bogo-switch">
                    <input type="checkbox" id="free_rule_enabled" name="free_rule_enabled" <?php checked( $rule['enabled'], 1 ); ?>>
                    <span class="gt-bogo-slider"></span>
                </label>

                <p class="gt-bogo-field-desc">
                    <?php esc_html_e( 'When turned off, the rule will not apply.', 'gt-bogo-engine' ); ?>
                </p>
            </div>
        </div>

        <!-- BASIC CONFIG -->
        <div class="gt-bogo-engine-panel">
            <h2><?php esc_html_e( 'Basic Configuration', 'gt-bogo-engine' ); ?></h2>

            <!-- Title -->
            <div class="gt-bogo-engine-field">
                <label for="free_rule_title">
                    <?php esc_html_e( 'Rule Title', 'gt-bogo-engine' ); ?>
                </label>
                <input type="text" id="free_rule_title" name="free_rule_title" class="regular-text"
                       value="<?php echo esc_attr( $rule['title'] ); ?>">
            </div>

            <!-- Buy Qty -->
            <div class="gt-bogo-engine-field">
                <label for="free_rule_buy_qty">
                    <?php esc_html_e( 'Buy Quantity', 'gt-bogo-engine' ); ?>
                </label>
                <input type="number" id="free_rule_buy_qty" name="free_rule_buy_qty" min="1" 
                       value="<?php echo intval( $rule['buy_qty'] ); ?>" class="small-text">
            </div>

            <!-- Get Qty -->
            <div class="gt-bogo-engine-field">
                <label for="free_rule_get_qty">
                    <?php esc_html_e( 'Get Quantity', 'gt-bogo-engine' ); ?>
                </label>
                <input type="number" id="free_rule_get_qty" name="free_rule_get_qty" min="1"
                       value="<?php echo intval( $rule['get_qty'] ); ?>" class="small-text">
            </div>

            <!-- Discount Type -->
            <div class="gt-bogo-engine-field">
                <label for="free_rule_discount_type">
                    <?php esc_html_e( 'Discount Type', 'gt-bogo-engine' ); ?>
                </label>

                <select id="free_rule_discount_type" name="free_rule_discount_type">
                    <option value="percent" <?php selected( $rule['discount_type'], 'percent' ); ?>>
                        <?php esc_html_e( 'Percentage (%)', 'gt-bogo-engine' ); ?>
                    </option>
                    <option value="fixed" <?php selected( $rule['discount_type'], 'fixed' ); ?>>
                        <?php esc_html_e( 'Fixed Amount', 'gt-bogo-engine' ); ?>
                    </option>
                    <option value="free" <?php selected( $rule['discount_type'], 'free' ); ?>>
                        <?php esc_html_e( 'Free Item', 'gt-bogo-engine' ); ?>
                    </option>
                </select>
            </div>

            <!-- Discount Amount -->
            <div class="gt-bogo-engine-field">
                <label for="free_rule_discount_value">
                    <?php esc_html_e( 'Discount Value', 'gt-bogo-engine' ); ?>
                </label>
                <input type="number" step="0.01" min="0" id="free_rule_discount_value"
                       name="free_rule_discount_value"
                       value="<?php echo esc_attr( $rule['discount_value'] ); ?>"
                       <?php echo ($rule['discount_type'] === 'free') ? 'disabled' : ''; ?>>
            </div>
        </div>

        <!-- SCOPE -->
        <div class="gt-bogo-engine-panel">
            <h2><?php esc_html_e( 'Rule Scope', 'gt-bogo-engine' ); ?></h2>

            <div class="gt-bogo-engine-field">
                <label for="free_rule_scope">
                    <?php esc_html_e( 'Applies To', 'gt-bogo-engine' ); ?>
                </label>

                <select id="free_rule_scope" name="free_rule_scope">
                    <option value="global" <?php selected( $rule['scope'], 'global' ); ?>>
                        <?php esc_html_e( 'Entire Store (Global)', 'gt-bogo-engine' ); ?>
                    </option>
                    <option value="categories" <?php selected( $rule['scope'], 'categories' ); ?>>
                        <?php esc_html_e( 'Specific Categories', 'gt-bogo-engine' ); ?>
                    </option>
                    <option value="products" <?php selected( $rule['scope'], 'products' ); ?>>
                        <?php esc_html_e( 'Specific Products', 'gt-bogo-engine' ); ?>
                    </option>
                </select>
            </div>

            <!-- Categories -->
            <div class="gt-bogo-engine-field gt-bogo-conditional" data-condition="categories">
                <label><?php esc_html_e( 'Choose Categories', 'gt-bogo-engine' ); ?></label>
                <?php
                wp_dropdown_categories( array(
                    'taxonomy'   => 'product_cat',
                    'name'       => 'free_rule_categories[]',
                    'orderby'    => 'name',
                    'hide_empty' => false,
                    'multiple'   => true,
                    'selected'   => $rule['categories'],
                ) );
                ?>
            </div>

            <!-- Products -->
            <div class="gt-bogo-engine-field gt-bogo-conditional" data-condition="products">
                <label><?php esc_html_e( 'Choose Products', 'gt-bogo-engine' ); ?></label>

                <select name="free_rule_products[]" multiple style="min-width: 260px;">
                    <?php
                    $products = wc_get_products( array(
                        'limit' => -1,
                        'orderby' => 'title',
                        'order' => 'ASC',
                    ) );

                    foreach ( $products as $p ) {
                        echo '<option value="' . esc_attr( $p->get_id() ) . '" ' .
                             selected( in_array( $p->get_id(), $rule['products'] ), true, false ) . '>' .
                             esc_html( $p->get_name() ) .
                             '</option>';
                    }
                    ?>
                </select>
            </div>
        </div>

        <!-- SAVE -->
        <div class="gt-bogo-engine-panel gt-bogo-engine-panel-save">
            <button type="submit" class="button button-primary">
                <?php esc_html_e( 'Save Free Rule', 'gt-bogo-engine' ); ?>
            </button>
            <span class="gt-bogo-autosave-status"></span>
        </div>

    </form>

</div>

