<?php
/**
 * Import / Export Page (PRO)
 *
 * @package GT_BOGO_Engine
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

require_once dirname( __FILE__ ) . '/partials/brand-header.php';

// License check
$lic_ok = false;
if ( class_exists( 'GT_BOGO_Engine_License' ) ) {
    try {
        $lic = new GT_BOGO_Engine_License();
        if ( method_exists( $lic, 'is_valid' ) ) {
            $lic_ok = (bool) $lic->is_valid();
        }
    } catch ( Throwable $e ) {
        $lic_ok = false;
    }
}
?>
<div class="gtbe-wrap gt-bogo-page-wrap">
    <div class="gtbe-hero">
        <div class="gtbe-title">Import / Export</div>
        <div class="gtbe-subtitle">Move BOGO campaigns between stores, restore backups, and deploy PRO Rule Packs using JSON files.</div>
    </div>

    <?php if ( ! $lic_ok ) : ?>
        <div class="gtbe-grid">
            <div class="gtbe-card">
                <h3>Import PRO Rule Files (JSON)</h3>
                <p>Import professionally configured GT BOGO rules from a JSON file. Imported rules appear instantly in <strong>PRO Rules</strong>.</p>
                <ul>
                    <li>Accepted format: <strong>.json</strong></li>
                    <li>Best for backups, migrations, and PRO Rule Packs</li>
                    <li>Fast deployment with enterprise-safe defaults</li>
                </ul>
                <a class="gtbe-btn" href="https://graphictshirts.shop/bogo/" target="_blank" rel="noopener">Upgrade to PRO to Import</a>
            </div>

            <div class="gtbe-card">
                <h3>Export Your Rules</h3>
                <p>Export your rules to JSON for backup, migration, or reuse across stores. Protect your discount strategy with a clean rollback path.</p>
                <ul>
                    <li>Export full rule sets or selected rules</li>
                    <li>Recommended before major changes</li>
                    <li>Designed for future GT BOGO ENGINE compatibility</li>
                </ul>
                <a class="gtbe-btn" href="https://graphictshirts.shop/bogo/" target="_blank" rel="noopener">Upgrade to PRO to Export</a>
            </div>

            <div class="gtbe-card">
                <h3>PRO Rule Packs</h3>
                <p>PRO Packs are pre-built discount strategies delivered as importable JSON files. Purchase a pack, then import it here to deploy instantly.</p>
                <ul>
                    <li>BOGO stacks & tiered offers</li>
                    <li>Cart-threshold rewards</li>
                    <li>Category & product targeting</li>
                    <li>Schedule-based flash campaigns</li>
                </ul>
                <a class="gtbe-btn" href="https://graphictshirts.shop/bogo/" target="_blank" rel="noopener">View PRO Packs</a>
            </div>
        </div>

        <div class="gtbe-card" style="margin-top:14px;">
            <h3>Security Note</h3>
            <p>GT BOGO ENGINE does not transmit your store rules to third parties. Imports and exports are handled locally inside your WordPress admin.</p>
        </div>
    <?php else : ?>
        <div class="gtbe-grid">
            <div class="gtbe-card">
                <h3>Import (PRO)</h3>
                <p>Select a JSON export file and import it to create ready-to-run PRO rules.</p>
                <p><em>Import UI will appear here for licensed customers.</em></p>
                <button class="gtbe-btn" disabled>Choose JSON File</button>
            </div>

            <div class="gtbe-card">
                <h3>Export (PRO)</h3>
                <p>Export your rules to a JSON file for backup and migration.</p>
                <p><em>Export UI will appear here for licensed customers.</em></p>
                <button class="gtbe-btn" disabled>Export Rules</button>
            </div>
        </div>
    <?php endif; ?>
</div>
