<?php
/**
 * GT BOGO Engine – PRO Rules Page (Premium UI)
 *
 * Location: includes/admin/views/page-pro-rules.php
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
require_once dirname( __FILE__ ) . '/partials/brand-header.php';


$lic_ok = false;
if ( class_exists( 'GT_BOGO_Engine_License' ) ) {
    $lic = GT_BOGO_Engine_License::instance();
    $lic->ensure_validated();
    $lic_ok = $lic->is_pro_active();
}

if ( ! $lic_ok ) {
    ?>
    <div class="gtbe-wrap">
        <div class="gtbe-hero">
            <div class="gtbe-hero-left">
                <div class="gtbe-title">PRO Rules</div>
                <div class="gtbe-subtitle">This section is available to PRO license holders only.</div>
            </div>
        </div>
        <div class="gtbe-grid">
            <div class="gtbe-card">
                <h3>Unlock PRO Rules</h3>
                <p>Purchase a 1-year PRO license to unlock stacking rules, scheduling, cart conditions, and Import/Export of JSON rule files.</p>
                <a class="gtbe-btn" href="https://graphictshirts.shop/bogo/" target="_blank" rel="noopener">Get PRO License</a>
            </div>
        </div>
    </div>
    <?php
    return;
}


$rules = get_option( 'gt_bogo_engine_rules', array() );

$base_url = admin_url( 'admin.php?page=gt-bogo-engine' );
$dashboard_url = $base_url;
$settings_url = add_query_arg( 'tab', 'settings', $base_url );
$free_rule_url = add_query_arg( 'tab', 'free_rule', $base_url );
$pro_rules_url = add_query_arg( 'tab', 'pro_rules', $base_url );
$import_url = add_query_arg( 'tab', 'import_export', $base_url );
$license_url = add_query_arg( 'tab', 'license', $base_url );
$welcome_url = add_query_arg( 'tab', 'welcome', $base_url );
$docs_url = add_query_arg( 'tab', 'docs', $base_url );

?>

<div class="wrap gt-bogo-engine-wrap">

    <!-- Header -->
    <div class="gt-bogo-engine-header">
        <div>
            <h1><?php esc_html_e( 'PRO BOGO Rules', 'gt-bogo-engine' ); ?></h1>
            <p><?php esc_html_e( 'Create unlimited advanced BOGO rules with custom conditions.', 'gt-bogo-engine' ); ?></p>
        </div>

        <!-- Badge -->
        <div class="gt-bogo-pro-header-badge">PRO</div>
    </div>

    <!-- Tabs -->
    <nav class="gt-bogo-engine-tabs">
        <a href="<?php echo esc_url( $dashboard_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Dashboard', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $settings_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Settings', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $free_rule_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Free Core Rule', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $pro_rules_url ); ?>" class="gt-bogo-engine-tab is-active">
            <?php esc_html_e( 'PRO Rules', 'gt-bogo-engine' ); ?>
            <span class="gt-bogo-engine-badge gt-bogo-engine-badge-pro">PRO</span>
        </a>
        <a href="<?php echo esc_url( $import_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Import / Export', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $license_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'License', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $welcome_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Welcome', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $docs_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Docs', 'gt-bogo-engine' ); ?>
        </a>
    </nav>


    <!-- PRO Rule Builder -->
    <form method="post" id="gt-bogo-engine-pro-rules-form" class="gt-bogo-engine-form" data-context="pro_rules">

        <div id="gt-bogo-pro-rules-container">

            <?php if ( empty( $rules ) ) : ?>

                <div class="gt-bogo-no-rules">
                    <p><?php esc_html_e( 'No PRO rules defined yet. Click “Add New Rule.”', 'gt-bogo-engine' ); ?></p>
                </div>

            <?php else : ?>

                <?php foreach ( $rules as $index => $rule ) : ?>

                    <div class="gt-bogo-pro-rule-card" data-rule-index="<?php echo esc_attr( $index ); ?>">

                        <!-- Header -->
                        <div class="gt-bogo-pro-rule-header">
                            <div class="gt-bogo-pro-rule-title">
                                <strong><?php echo esc_html( $rule['title'] ); ?></strong>
                            </div>

                            <div class="gt-bogo-pro-rule-actions">
                                <span class="gt-bogo-reorder-handle">☰</span>

                                <button type="button"
                                        class="button-link-delete gt-bogo-delete-rule"
                                        data-index="<?php echo esc_attr( $index ); ?>">
                                    <?php esc_html_e( 'Delete', 'gt-bogo-engine' ); ?>
                                </button>
                            </div>
                        </div>

                        <!-- Fields -->
                        <div class="gt-bogo-pro-rule-fields">

                            <!-- Enabled -->
                            <div class="gt-bogo-engine-field">
                                <label>
                                    <?php esc_html_e( 'Enable this rule', 'gt-bogo-engine' ); ?>
                                </label>
                                <label class="gt-bogo-switch">
                                    <input type="checkbox"
                                           name="rules[<?php echo esc_attr( $index ); ?>][enabled]"
                                           <?php checked( $rule['enabled'], 1 ); ?>>
                                    <span class="gt-bogo-slider"></span>
                                </label>
                            </div>

                            <!-- Title -->
                            <div class="gt-bogo-engine-field">
                                <label><?php esc_html_e( 'Rule Title', 'gt-bogo-engine' ); ?></label>
                                <input type="text"
                                       name="rules[<?php echo esc_attr( $index ); ?>][title]"
                                       class="regular-text"
                                       value="<?php echo esc_attr( $rule['title'] ); ?>">
                            </div>

                            <!-- Buy Qty -->
                            <div class="gt-bogo-engine-field">
                                <label><?php esc_html_e( 'Buy Quantity', 'gt-bogo-engine' ); ?></label>
                                <input type="number" min="1"
                                       name="rules[<?php echo esc_attr( $index ); ?>][buy_qty]"
                                       class="small-text"
                                       value="<?php echo intval( $rule['buy_qty'] ); ?>">
                            </div>

                            <!-- Get Qty -->
                            <div class="gt-bogo-engine-field">
                                <label><?php esc_html_e( 'Get Quantity', 'gt-bogo-engine' ); ?></label>
                                <input type="number" min="1"
                                       name="rules[<?php echo esc_attr( $index ); ?>][get_qty]"
                                       class="small-text"
                                       value="<?php echo intval( $rule['get_qty'] ); ?>">
                            </div>

                            <!-- Discount Type -->
                            <div class="gt-bogo-engine-field">
                                <label><?php esc_html_e( 'Discount Type', 'gt-bogo-engine' ); ?></label>
                                <select name="rules[<?php echo esc_attr( $index ); ?>][discount_type]">
                                    <option value="percent" <?php selected( $rule['discount_type'], 'percent' ); ?>>
                                        <?php esc_html_e( 'Percentage (%)', 'gt-bogo-engine' ); ?>
                                    </option>
                                    <option value="fixed" <?php selected( $rule['discount_type'], 'fixed' ); ?>>
                                        <?php esc_html_e( 'Fixed Amount', 'gt-bogo-engine' ); ?>
                                    </option>
                                    <option value="free" <?php selected( $rule['discount_type'], 'free' ); ?>>
                                        <?php esc_html_e( 'Free Item', 'gt-bogo-engine' ); ?>
                                    </option>
                                </select>
                            </div>

                            <!-- Discount Value -->
                            <div class="gt-bogo-engine-field">
                                <label><?php esc_html_e( 'Discount Value', 'gt-bogo-engine' ); ?></label>
                                <input type="number" step="0.01" min="0"
                                       name="rules[<?php echo esc_attr( $index ); ?>][discount_value]"
                                       value="<?php echo esc_attr( $rule['discount_value'] ); ?>"
                                       <?php echo ($rule['discount_type'] === 'free') ? 'disabled' : ''; ?>>
                            </div>

                            <!-- Scope -->
                            <div class="gt-bogo-engine-field">
                                <label><?php esc_html_e( 'Applies To', 'gt-bogo-engine' ); ?></label>
                                <select name="rules[<?php echo esc_attr( $index ); ?>][scope]">
                                    <option value="global" <?php selected( $rule['scope'], 'global' ); ?>>
                                        <?php esc_html_e( 'Entire Store (Global)', 'gt-bogo-engine' ); ?>
                                    </option>
                                    <option value="categories" <?php selected( $rule['scope'], 'categories' ); ?>>
                                        <?php esc_html_e( 'Specific Categories', 'gt-bogo-engine' ); ?>
                                    </option>
                                    <option value="products" <?php selected( $rule['scope'], 'products' ); ?>>
                                        <?php esc_html_e( 'Specific Products', 'gt-bogo-engine' ); ?>
                                    </option>
                                </select>
                            </div>

                            <!-- Categories -->
                            <div class="gt-bogo-engine-field gt-bogo-conditional" data-condition="categories">
                                <label><?php esc_html_e( 'Choose Categories', 'gt-bogo-engine' ); ?></label>
                                <?php
                                wp_dropdown_categories( array(
                                    'taxonomy'   => 'product_cat',
                                    'name'       => "rules[{$index}][categories][]",
                                    'orderby'    => 'name',
                                    'hide_empty' => false,
                                    'multiple'   => true,
                                    'selected'   => $rule['categories'],
                                ) );
                                ?>
                            </div>

                            <!-- Products -->
                            <div class="gt-bogo-engine-field gt-bogo-conditional" data-condition="products">
                                <label><?php esc_html_e( 'Choose Products', 'gt-bogo-engine' ); ?></label>

                                <select name="rules[<?php echo esc_attr( $index ); ?>][products][]" multiple style="min-width: 260px;">
                                    <?php
                                    $products = wc_get_products( array(
                                        'limit' => -1,
                                        'orderby' => 'title',
                                        'order'   => 'ASC'
                                    ) );
                                    foreach ( $products as $p ) {
                                        echo '<option value="' . esc_attr( $p->get_id() ) . '" ' .
                                             selected( in_array( $p->get_id(), $rule['products'] ), true, false ) . '>' .
                                             esc_html( $p->get_name() ) .
                                             '</option>';
                                    }
                                    ?>
                                </select>
                            </div>

                        </div><!-- end fields -->
                    </div><!-- end card -->

                <?php endforeach; ?>

            <?php endif; ?>
        </div>

        <!-- Add New Rule Button -->
        <div class="gt-bogo-engine-panel">
            <button type="button" id="gt-bogo-add-pro-rule" class="button button-secondary">
                + <?php esc_html_e( 'Add New Rule', 'gt-bogo-engine' ); ?>
            </button>
        </div>

        <!-- Save -->
        <div class="gt-bogo-engine-panel gt-bogo-engine-panel-save">
            <button type="submit" class="button button-primary">
                <?php esc_html_e( 'Save PRO Rules', 'gt-bogo-engine' ); ?>
            </button>
            <span class="gt-bogo-autosave-status"></span>
        </div>

    </form>

</div>

