<?php
/**
 * GT BOGO Engine — Settings Page (Premium Version)
 *
 * Location: includes/admin/views/page-settings.php
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
require_once dirname( __FILE__ ) . '/partials/brand-header.php';


$settings = get_option( 'gt_bogo_engine_settings', array(
    'enable_engine'  => 1,
    'debug_mode'     => 0,
    'pro_nag_hidden' => 0,
) );

$base_url       = admin_url( 'admin.php?page=gt-bogo-engine' );
$dashboard_url  = $base_url;
$settings_url   = add_query_arg( 'tab', 'settings', $base_url );
$free_rule_url  = add_query_arg( 'tab', 'free_rule', $base_url );
$pro_rules_url  = add_query_arg( 'tab', 'pro_rules', $base_url );
$import_url     = add_query_arg( 'tab', 'import_export', $base_url );
$license_url    = add_query_arg( 'tab', 'license', $base_url );
$welcome_url    = add_query_arg( 'tab', 'welcome', $base_url );
$docs_url       = add_query_arg( 'tab', 'docs', $base_url );

?>

<div class="wrap gt-bogo-engine-wrap">

    <!-- Header -->
    <div class="gt-bogo-engine-header">
        <div>
            <h1><?php esc_html_e( 'GT BOGO Engine Settings', 'gt-bogo-engine' ); ?></h1>
            <p><?php esc_html_e( 'Core plugin configuration and global behavior.', 'gt-bogo-engine' ); ?></p>
        </div>
        <div class="gt-bogo-pro-header-badge">Settings</div>
    </div>

    <!-- Tabs -->
    <nav class="gt-bogo-engine-tabs">
        <a href="<?php echo esc_url( $dashboard_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Dashboard', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $settings_url ); ?>" class="gt-bogo-engine-tab is-active">
            <?php esc_html_e( 'Settings', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $free_rule_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Free Core Rule', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $pro_rules_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'PRO Rules', 'gt-bogo-engine' ); ?>
            <span class="gt-bogo-engine-badge gt-bogo-engine-badge-pro">PRO</span>
        </a>
        <a href="<?php echo esc_url( $import_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Import / Export', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $license_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'License', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $welcome_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Welcome', 'gt-bogo-engine' ); ?>
        </a>
        <a href="<?php echo esc_url( $docs_url ); ?>" class="gt-bogo-engine-tab">
            <?php esc_html_e( 'Docs', 'gt-bogo-engine' ); ?>
        </a>
    </nav>

    <!-- Settings Form -->
    <form method="post" id="gt-bogo-engine-settings-form" class="gt-bogo-engine-form" data-context="settings">

        <div class="gt-bogo-engine-card">

            <h2 class="gt-bogo-card-title">
                <?php esc_html_e( 'Global Settings', 'gt-bogo-engine' ); ?>
            </h2>

            <!-- Enable Engine -->
            <div class="gt-bogo-engine-field">
                <label><?php esc_html_e( 'Enable BOGO Engine', 'gt-bogo-engine' ); ?></label>
                <label class="gt-bogo-switch">
                    <input type="checkbox"
                           name="enable_engine"
                           <?php checked( $settings['enable_engine'], 1 ); ?>>
                    <span class="gt-bogo-slider"></span>
                </label>
                <p class="description">
                    <?php esc_html_e( 'Turn the entire engine on or off globally.', 'gt-bogo-engine' ); ?>
                </p>
            </div>

            <!-- Debug Mode -->
            <div class="gt-bogo-engine-field">
                <label><?php esc_html_e( 'Enable Debug Mode', 'gt-bogo-engine' ); ?></label>
                <label class="gt-bogo-switch">
                    <input type="checkbox"
                           name="debug_mode"
                           <?php checked( $settings['debug_mode'], 1 ); ?>>
                    <span class="gt-bogo-slider"></span>
                </label>
                <p class="description">
                    <?php esc_html_e( 'Show detailed debug info in the cart & logs (for troubleshooting).', 'gt-bogo-engine' ); ?>
                </p>
            </div>

            <!-- Hide Pro Nag -->
            <div class="gt-bogo-engine-field">
                <label><?php esc_html_e( 'Hide PRO Marketing Banner', 'gt-bogo-engine' ); ?></label>
                <label class="gt-bogo-switch">
                    <input type="checkbox"
                           name="pro_nag_hidden"
                           <?php checked( $settings['pro_nag_hidden'], 1 ); ?>>
                    <span class="gt-bogo-slider"></span>
                </label>
                <p class="description">
                    <?php esc_html_e( 'Hides the promotional PRO banner across the plugin.', 'gt-bogo-engine' ); ?>
                </p>
            </div>

        </div>

        <!-- Save Button -->
        <div class="gt-bogo-engine-panel gt-bogo-engine-panel-save">
            <button type="submit" class="button button-primary">
                <?php esc_html_e( 'Save Settings', 'gt-bogo-engine' ); ?>
            </button>
            <span class="gt-bogo-autosave-status"></span>
        </div>

    </form>

</div>

