<?php
/**
 * GT BOGO Engine – Sidebar Navigation
 * Premium UI navigation for all admin pages
 */

if (!defined('ABSPATH')) exit;

// Current tab
$active = isset($_GET['tab']) ? sanitize_text_field($_GET['tab']) : 'dashboard';
?>

<div class="gt-bogo-sidebar">

    <div class="gt-bogo-sidebar-header">
        <img src="<?php echo esc_url( GT_BOGO_ENGINE_URL . 'assets/img/icon-128.png' ); ?>" alt="GT BOGO Logo">
        <h3>GT BOGO Engine</h3>
        <span class="version">v<?php echo esc_html(GT_BOGO_ENGINE_VERSION); ?></span>
    </div>

    <ul class="gt-bogo-sidebar-menu">

        <li class="<?php echo $active === 'dashboard' ? 'active' : ''; ?>">
            <a href="admin.php?page=gt-bogo-engine&tab=dashboard">
                <span class="dashicons dashicons-chart-line"></span>
                <?php _e('Dashboard', 'gt-bogo-engine'); ?>
            </a>
        </li>

        <li class="<?php echo $active === 'settings' ? 'active' : ''; ?>">
            <a href="admin.php?page=gt-bogo-engine&tab=settings">
                <span class="dashicons dashicons-admin-generic"></span>
                <?php _e('Settings', 'gt-bogo-engine'); ?>
            </a>
        </li>

        <li class="<?php echo $active === 'free_rule' ? 'active' : ''; ?>">
            <a href="admin.php?page=gt-bogo-engine&tab=free_rule">
                <span class="dashicons dashicons-star-half"></span>
                <?php _e('Free Rule', 'gt-bogo-engine'); ?>
            </a>
        </li>

        <li class="<?php echo $active === 'pro_rules' ? 'active' : ''; ?>">
            <a href="admin.php?page=gt-bogo-engine&tab=pro_rules">
                <span class="dashicons dashicons-awards"></span>
                <?php _e('PRO Rules', 'gt-bogo-engine'); ?>
                <span class="gt-bogo-pro-badge">PRO</span>
            </a>
        </li>

        <li class="<?php echo $active === 'import_export' ? 'active' : ''; ?>">
            <a href="admin.php?page=gt-bogo-engine&tab=import_export">
                <span class="dashicons dashicons-migrate"></span>
                <?php _e('Import / Export', 'gt-bogo-engine'); ?>
            </a>
        </li>

        <li class="<?php echo $active === 'license' ? 'active' : ''; ?>">
            <a href="admin.php?page=gt-bogo-engine&tab=license">
                <span class="dashicons dashicons-lock"></span>
                <?php _e('License', 'gt-bogo-engine'); ?>
            </a>
        </li>

        <li class="<?php echo $active === 'docs' ? 'active' : ''; ?>">
            <a href="admin.php?page=gt-bogo-engine&tab=docs">
                <span class="dashicons dashicons-media-document"></span>
                <?php _e('Documentation', 'gt-bogo-engine'); ?>
            </a>
        </li>

        <li class="<?php echo $active === 'welcome' ? 'active' : ''; ?>">
            <a href="admin.php?page=gt-bogo-engine&tab=welcome">
                <span class="dashicons dashicons-smiley"></span>
                <?php _e('Welcome', 'gt-bogo-engine'); ?>
            </a>
        </li>
    </ul>

    <div class="gt-bogo-sidebar-footer">
        <p>Built by <a href="https://graphictshirts.shop" target="_blank">GRAPHIC T-SHIRTS</a></p>
        <a href="https://graphictshirts.shop/bogo" target="_blank" class="gt-bogo-pro-upgrade">
            <span class="dashicons dashicons-superhero"></span>
            Upgrade to PRO
        </a>
    </div>

</div>

