<?php
/**
 * Admin scripts & styles for GT BOGO Engine.
 *
 * @package GT_BOGO_Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

class GT_BOGO_Admin_Assets {

	/**
	 * Initialize hooks.
	 */
	public static function init() {
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_assets' ) );
	}

	/**
	 * Determine if current admin page belongs to GT BOGO Engine.
	 *
	 * @return bool
	 */
	private static function is_bogo_screen() {
		if ( empty( $_GET['page'] ) ) { // phpcs:ignore WordPress.Security.NonceVerification.Recommended
			return false;
		}

		$page = sanitize_text_field( wp_unslash( $_GET['page'] ) ); // phpcs:ignore WordPress.Security.NonceVerification.Recommended

		return in_array(
			$page,
			array(
				'gt-bogo-engine',
				'gt-bogo-engine-free',
				'gt-bogo-engine-pro',
				'gt-bogo-engine-settings',
				'gt-bogo-engine-logs',
				'gt-bogo-engine-help',
			),
			true
		);
	}

	/**
	 * Enqueue styles and scripts.
	 *
	 * @param string $hook
	 */
	public static function enqueue_assets( $hook ) {

		if ( ! self::is_bogo_screen() ) {
			return;
		}

		// ----------------------------
		// CSS
		// ----------------------------
		wp_enqueue_style(
			'gt-bogo-admin-css',
			GT_BOGO_ENGINE_URL . 'assets/css/admin.css',
			array(),
			GT_BOGO_ENGINE_VERSION
		);

		// ----------------------------
		// JS
		// ----------------------------
		wp_enqueue_script(
			'gt-bogo-admin-js',
			GT_BOGO_ENGINE_URL . 'assets/js/admin.js',
			array( 'jquery' ),
			GT_BOGO_ENGINE_VERSION,
			true
		);

		// Localized data for JS
		wp_localize_script(
			'gt-bogo-admin-js',
			'gtBogoData',
			array(
				'ajax_url'  => admin_url( 'admin-ajax.php' ),
				'pro_url'   => 'https://graphictshirts.shop/bogo',
				'save_text' => __( 'Saving...', 'gt-bogo-engine' ),
			)
		);

		// jQuery UI for sliders, dialogs, sortable lists, etc.
		wp_enqueue_script( 'jquery-ui-sortable' );
		wp_enqueue_script( 'jquery-ui-dialog' );
		wp_enqueue_style( 'wp-jquery-ui-dialog' );
	}
}

GT_BOGO_Admin_Assets::init();

