<?php
/**
 * GT BOGO Rules Engine – PRO Rules UI (Premium Features)
 *
 * This file renders the PRO rules tab — allowing multiple BOGO rules
 * with conditions, scopes, scheduling, and discount controls.
 *
 * The full functionality unlocks only when PRO is installed/activated.
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class GT_BOGO_Engine_Pro_Rules {

    private static $instance = null;

    /**
     * Singleton
     */
    public static function instance() {
        if ( self::$instance === null ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * Init
     */
    private function __construct() {
        add_action( 'gt_bogo_engine_render_tab_pro', array( $this, 'render_page' ) );

        // For later PRO expansion:
        add_action( 'admin_post_gt_bogo_save_pro_rule', array( $this, 'save_rule' ) );
        add_action( 'admin_post_gt_bogo_delete_pro_rule', array( $this, 'delete_rule' ) );
    }

    /**
     * Get all PRO rules
     */
    public function get_rules() {
        $rules = get_option( 'gt_bogo_engine_rules', array() );

        if ( ! is_array( $rules ) ) {
            $rules = array();
        }

        return $rules;
    }

    /**
     * Save rule (inactive until PRO available)
     */
    public function save_rule() {

        // PRO required
        wp_die( 'PRO version required for multiple advanced rules.' );
    }

    /**
     * Delete rule (inactive until PRO available)
     */
    public function delete_rule() {

        // PRO required
        wp_die( 'PRO version required for multiple advanced rules.' );
    }

    /**
     * Render the PRO rules admin screen
     */
    public function render_page() {

        $rules = $this->get_rules();
        ?>

        <div class="gt-bogo-card">

            <div class="gt-bogo-card-header">
                <h2>Advanced BOGO Rules (PRO)</h2>
                <p>Create unlimited Buy X Get Y promotions with fine-tuned logic, scheduling, and targeting.</p>
            </div>

            <div class="gt-bogo-card-content">

                <?php if ( empty( $rules ) ) : ?>

                    <div class="gt-bogo-pro-upsell">
                        <h3>Unlock Unlimited BOGO Rules</h3>
                        <p>
                            With <strong>GT BOGO Engine PRO</strong>, you can create a complete rules library:
                        </p>

                        <ul class="gt-bogo-checklist">
                            <li>✓ Multiple simultaneous BOGO rules</li>
                            <li>✓ Category & product targeting</li>
                            <li>✓ Conditional logic (roles, cart total, quantity, schedules)</li>
                            <li>✓ Free items, cheapest item, discounted bundles</li>
                            <li>✓ Advanced discount stacking logic</li>
                            <li>✓ Custom promotional banners</li>
                            <li>✓ Priority and conflict resolution</li>
                        </ul>

                        <div class="gt-bogo-upsell-cta">
                            <a href="https://graphictshirts.shop/bogo" target="_blank" class="button button-primary button-large">
                                Get PRO Version – $19.99/year
                            </a>
                        </div>

                        <p class="gt-bogo-upsell-note">
                            Instant license delivery • One site • 1-year updates • Built by GRAPHIC T-SHIRTS
                        </p>
                    </div>

                <?php else : ?>

                    <div class="gt-bogo-pro-rule-header">
                        <h3>Your PRO Rules</h3>

                        <button class="button button-primary gt-bogo-open-create-modal">
                            + Create New Rule
                        </button>
                    </div>

                    <table class="wp-list-table widefat striped gt-bogo-table">
                        <thead>
                            <tr>
                                <th>Rule Name</th>
                                <th>Type</th>
                                <th>Scope</th>
                                <th>Status</th>
                                <th>Schedule</th>
                                <th style="width:110px;">Actions</th>
                            </tr>
                        </thead>

                        <tbody>
                            <?php foreach ( $rules as $rule_id => $rule ) : ?>
                                <tr>
                                    <td><?php echo esc_html( $rule['title'] ); ?></td>
                                    <td><?php echo esc_html( ucfirst( $rule['type'] ) ); ?></td>
                                    <td><?php echo esc_html( ucfirst( $rule['scope'] ) ); ?></td>
                                    <td>
                                        <?php if ( $rule['enabled'] ) : ?>
                                            <span class="gt-bogo-status-enabled">Enabled</span>
                                        <?php else : ?>
                                            <span class="gt-bogo-status-disabled">Disabled</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if ( ! empty( $rule['schedule_start'] ) || ! empty( $rule['schedule_end'] ) ) : ?>
                                            <?php echo esc_html( $rule['schedule_start'] ); ?> → <?php echo esc_html( $rule['schedule_end'] ); ?>
                                        <?php else : ?>
                                            <em>Always active</em>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="#" class="button button-small disabled">Edit</a>
                                        <a href="#" class="button button-small disabled">Delete</a>
                                        <span class="gt-bogo-pro-lock" title="PRO feature">🔒</span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>

                    </table>

                <?php endif; ?>

            </div>
        </div>

        <!-- MODAL (disabled, but UI present for premium look) -->
        <div class="gt-bogo-modal" id="gt-bogo-create-rule-modal">

            <div class="gt-bogo-modal-content">
                <h2>Create New PRO BOGO Rule</h2>

                <p class="gt-bogo-pro-locked">
                    This feature is part of the <strong>PRO version</strong>.
                </p>

                <a href="https://graphictshirts.shop/bogo" target="_blank" class="button button-primary button-large">
                    Unlock PRO – $19.99/year
                </a>

                <button class="button gt-bogo-modal-close">Close</button>
            </div>

        </div>

        <?php
    }
}

GT_BOGO_Engine_Pro_Rules::instance();

