<?php
/**
 * Free rule tab view.
 *
 * @var GT_BOGO_Engine $engine
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$free = $engine->get_free_rule();

// Product categories and products for selectors.
$categories = get_terms( array(
    'taxonomy'   => 'product_cat',
    'hide_empty' => false,
) );

$products = wc_get_products( array(
    'limit'  => 50,
    'status' => 'publish',
    'orderby'=> 'title',
    'order'  => 'ASC',
) );
?>
<div class="gt-bogo-engine-panel">
    <h2><?php esc_html_e( 'Free Core Rule – Global BOGO', 'gt-bogo-engine' ); ?></h2>
    <p><?php esc_html_e( 'This rule is always available in the free version. It lets you run a single “Buy X Get Y at % off” promotion.', 'gt-bogo-engine' ); ?></p>

    <form method="post" class="gt-bogo-engine-form">
        <?php wp_nonce_field( 'gt_bogo_engine_save_free_rule', '_wpnonce' ); ?>
        <input type="hidden" name="gt_bogo_engine_action" value="save_free_rule"/>

        <table class="form-table gt-bogo-engine-form-table">
            <tr>
                <th scope="row">
                    <label for="free_enabled"><?php esc_html_e( 'Enable Free Rule', 'gt-bogo-engine' ); ?></label>
                </th>
                <td>
                    <label>
                        <input type="checkbox" id="free_enabled" name="free_enabled" value="1"
                            <?php checked( ! empty( $free['enabled'] ) ); ?> />
                        <?php esc_html_e( 'Turn on the global BOGO promotion.', 'gt-bogo-engine' ); ?>
                    </label>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <label for="free_title"><?php esc_html_e( 'Rule Name', 'gt-bogo-engine' ); ?></label>
                </th>
                <td>
                    <input type="text" id="free_title" name="free_title" class="regular-text"
                           value="<?php echo esc_attr( $free['title'] ); ?>" />
                    <p class="description">
                        <?php esc_html_e( 'Internal name for this rule. You can describe the offer here.', 'gt-bogo-engine' ); ?>
                    </p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Buy / Get Quantities', 'gt-bogo-engine' ); ?></th>
                <td class="gt-bogo-engine-bogo-quantities">
                    <label>
                        <?php esc_html_e( 'Buy', 'gt-bogo-engine' ); ?>
                        <input type="number" min="1" step="1" name="free_buy_qty" value="<?php echo esc_attr( $free['buy_qty'] ); ?>" />
                    </label>
                    <span class="gt-bogo-engine-bogo-math">→</span>
                    <label>
                        <?php esc_html_e( 'Get', 'gt-bogo-engine' ); ?>
                        <input type="number" min="1" step="1" name="free_get_qty" value="<?php echo esc_attr( $free['get_qty'] ); ?>" />
                    </label>
                    <p class="description">
                        <?php esc_html_e( 'Example: Buy 1 Get 1 at 50% off.', 'gt-bogo-engine' ); ?>
                    </p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Discount', 'gt-bogo-engine' ); ?></th>
                <td>
                    <select name="free_discount_type">
                        <option value="percent" <?php selected( $free['discount_type'], 'percent' ); ?>>
                            <?php esc_html_e( 'Percentage (%)', 'gt-bogo-engine' ); ?>
                        </option>
                        <option value="fixed" <?php selected( $free['discount_type'], 'fixed' ); ?>>
                            <?php esc_html_e( 'Fixed amount', 'gt-bogo-engine' ); ?>
                        </option>
                    </select>
                    <input type="number" step="0.01" name="free_discount_value" value="<?php echo esc_attr( $free['discount_value'] ); ?>" />
                    <p class="description">
                        <?php esc_html_e( 'If you choose percentage, enter 50 for 50% off. If fixed, enter the amount to subtract from the discounted item.', 'gt-bogo-engine' ); ?>
                    </p>
                </td>
            </tr>

            <tr>
                <th scope="row"><?php esc_html_e( 'Scope', 'gt-bogo-engine' ); ?></th>
                <td>
                    <fieldset>
                        <label>
                            <input type="radio" name="free_scope" value="global"
                                <?php checked( $free['scope'], 'global' ); ?> />
                            <?php esc_html_e( 'Entire store (all products)', 'gt-bogo-engine' ); ?>
                        </label><br/>

                        <label>
                            <input type="radio" name="free_scope" value="categories"
                                <?php checked( $free['scope'], 'categories' ); ?> />
                            <?php esc_html_e( 'Specific categories', 'gt-bogo-engine' ); ?>
                        </label><br/>

                        <label>
                            <input type="radio" name="free_scope" value="products"
                                <?php checked( $free['scope'], 'products' ); ?> />
                            <?php esc_html_e( 'Specific products', 'gt-bogo-engine' ); ?>
                        </label>
                    </fieldset>

                    <div class="gt-bogo-engine-scope-categories" data-scope="categories">
                        <label>
                            <?php esc_html_e( 'Categories:', 'gt-bogo-engine' ); ?><br/>
                            <select name="free_categories[]" multiple="multiple" style="min-width:260px;">
                                <?php foreach ( $categories as $cat ) : ?>
                                    <option value="<?php echo esc_attr( $cat->term_id ); ?>"
                                        <?php selected( in_array( $cat->term_id, (array) $free['categories'], true ) ); ?>>
                                        <?php echo esc_html( $cat->name ); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </label>
                    </div>

                    <div class="gt-bogo-engine-scope-products" data-scope="products">
                        <label>
                            <?php esc_html_e( 'Products:', 'gt-bogo-engine' ); ?><br/>
                            <select name="free_products[]" multiple="multiple" style="min-width:260px;">
                                <?php foreach ( $products as $product ) : ?>
                                    <option value="<?php echo esc_attr( $product->get_id() ); ?>"
                                        <?php selected( in_array( $product->get_id(), (array) $free['products'], true ) ); ?>>
                                        <?php echo esc_html( $product->get_name() ); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </label>
                        <p class="description">
                            <?php esc_html_e( 'For large stores, you can leave this blank or use categories instead.', 'gt-bogo-engine' ); ?>
                        </p>
                    </div>
                </td>
            </tr>
        </table>

        <?php submit_button( __( 'Save Free Rule', 'gt-bogo-engine' ) ); ?>
    </form>
</div>
