<?php
/**
 * Documentation Page
 *
 * @package GT_BOGO_Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
require_once dirname( __FILE__ ) . '/partials/brand-header.php';

?>

<div class="wrap gt-bogo-engine-wrap gt-bogo-engine-docs-wrap">

    <h1 class="gt-bogo-page-title">
        <?php esc_html_e( 'GT BOGO ENGINE Documentation', 'gt-bogo-engine' ); ?>
    </h1>

    <p class="gt-bogo-lead">
        <?php esc_html_e( 'Learn how to build Buy X Get Y promotions, configure the free core rule, and manage advanced PRO rules.', 'gt-bogo-engine' ); ?>
    </p>

    <div class="gt-bogo-docs-grid">

        <!-- INTRODUCTION -->
        <div class="gt-bogo-docs-card">
            <h2><?php esc_html_e( 'Introduction', 'gt-bogo-engine' ); ?></h2>

            <p>
                <?php esc_html_e( 'GT BOGO Engine is a powerful discount system that runs inside the WooCommerce cart. It allows you to create Buy X Get Y logic without coupons, without shortcodes, and without modifying products.', 'gt-bogo-engine' ); ?>
            </p>

            <p>
                <?php esc_html_e( 'All rules are processed dynamically and apply automatically at checkout.', 'gt-bogo-engine' ); ?>
            </p>
        </div>

        <!-- FREE CORE RULE -->
        <div class="gt-bogo-docs-card">
            <h2><?php esc_html_e( 'Free Core Rule', 'gt-bogo-engine' ); ?></h2>

            <p>
                <?php esc_html_e( 'Your plugin includes one free rule: Buy 1 Get 1 at 50% Off. This rule is permanent, global, and always available.', 'gt-bogo-engine' ); ?>
            </p>

            <ul class="gt-bogo-bullet-list">
                <li><?php esc_html_e( 'Global scope (all products)', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Percent-based discount', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Runs automatically in the cart', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Can be enabled or disabled', 'gt-bogo-engine' ); ?></li>
            </ul>

            <a href="<?php echo esc_url( admin_url( 'admin.php?page=gt-bogo-engine&tab=free-rule' ) ); ?>"
               class="button button-secondary">
               <?php esc_html_e( 'Edit Free Core Rule', 'gt-bogo-engine' ); ?>
            </a>
        </div>

        <!-- PRO RULES -->
        <div class="gt-bogo-docs-card">
            <h2><?php esc_html_e( 'PRO Rules (Advanced)', 'gt-bogo-engine' ); ?></h2>

            <p>
                <?php esc_html_e( 'PRO mode unlocks advanced targeting, stacking, custom logic, and unlimited rules.', 'gt-bogo-engine' ); ?>
            </p>

            <ul class="gt-bogo-bullet-list">
                <li><?php esc_html_e( 'Buy X Get Y (any amounts)', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Category-specific promotions', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Product-specific promotions', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Cheapest-item discounts', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Unlimited rules running together', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Stacking and priority sorting', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Percentage or fixed discount logic', 'gt-bogo-engine' ); ?></li>
            </ul>

            <a class="button button-primary"
               href="https://graphictshirts.shop/bogo"
               target="_blank" rel="noopener noreferrer">
               <?php esc_html_e( 'View PRO Upgrade', 'gt-bogo-engine' ); ?>
            </a>
        </div>

        <!-- CART LOGIC -->
        <div class="gt-bogo-docs-card">
            <h2><?php esc_html_e( 'How Discounts Are Applied', 'gt-bogo-engine' ); ?></h2>

            <p><?php esc_html_e( 'GT BOGO Engine evaluates all cart items on every page load. When a rule qualifies:', 'gt-bogo-engine' ); ?></p>

            <ol class="gt-bogo-steps">
                <li><?php esc_html_e( 'The engine counts eligible items', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Checks Buy X thresholds', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Selects Get Y items', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Applies the configured discount', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Adds a transparent line item with the discount label', 'gt-bogo-engine' ); ?></li>
            </ol>

            <p class="gt-bogo-small">
                <?php esc_html_e( 'Discounts appear beneath the cart item prices and in checkout totals.', 'gt-bogo-engine' ); ?>
            </p>
        </div>

        <!-- IMPORT EXPORT -->
        <div class="gt-bogo-docs-card">
            <h2><?php esc_html_e( 'Import & Export Rules', 'gt-bogo-engine' ); ?></h2>

            <p>
                <?php esc_html_e( 'You can export all free + PRO rules into a JSON file and import them later on any site.', 'gt-bogo-engine' ); ?>
            </p>
            <div class="gt-bogo-docs-divider"></div>

            <h3><?php esc_html_e( 'Importing PRO Rule Packs (JSON)', 'gt-bogo-engine' ); ?></h3>

            <p>
                <?php esc_html_e( 'PRO Rule Packs are pre-configured discount strategies delivered as a JSON file. When you import a pack, GT BOGO ENGINE will create the included rules automatically so you can enable them instantly.', 'gt-bogo-engine' ); ?>
            </p>

            <ol class="gt-bogo-docs-list">
                <li><?php esc_html_e( 'Go to GT BOGO ENGINE → Import / Export.', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Click Import and select your .json file.', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Confirm the import to add the rules to this site.', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Review the imported rules, then enable the ones you want to run.', 'gt-bogo-engine' ); ?></li>
            </ol>

            <p>
                <?php esc_html_e( 'Tip: Keep your exported JSON files as backups. You can move your entire discount setup between sites in seconds.', 'gt-bogo-engine' ); ?>
            </p>


            <a href="<?php echo esc_url( admin_url( 'admin.php?page=gt-bogo-engine&tab=import-export' ) ); ?>"
               class="button button-secondary">
                <?php esc_html_e( 'Open Import / Export', 'gt-bogo-engine' ); ?>
            </a>
        </div>

        <!-- SUPPORT -->
        <div class="gt-bogo-docs-card">
            <h2><?php esc_html_e( 'Support & Contact', 'gt-bogo-engine' ); ?></h2>

            <p><?php esc_html_e( 'Need help? Contact GRAPHIC T-SHIRTS.', 'gt-bogo-engine' ); ?></p>

            <ul class="gt-bogo-brand-links">
                <li><a href="mailto:support@graphictshirts.shop">support@graphictshirts.shop</a></li>
                <li><a href="https://graphictshirts.shop/bogo" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'GT BOGO Sales Page', 'gt-bogo-engine' ); ?></a></li>
                <li><a href="https://graphictshirts.shop" target="_blank" rel="noopener noreferrer"><?php esc_html_e( 'Visit GRAPHIC T-SHIRTS', 'gt-bogo-engine' ); ?></a></li>
            </ul>

            <p class="gt-bogo-small gt-bogo-muted">
                <?php esc_html_e( 'Thank you for supporting independent creators. ❤️', 'gt-bogo-engine' ); ?>
            </p>
        </div>

    </div><!-- .gt-bogo-docs-grid -->

</div><!-- .gt-bogo-engine-docs-wrap -->

