<?php
/**
 * GT BOGO ENGINE – Free Core Rule Page
 * Path: /includes/admin/views/page-free-rule.php
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$rule = get_option('gt_bogo_engine_free_rule', array(
    'enabled'        => 1,
    'title'          => 'Buy 1 Get 1 at 50% Off (Global)',
    'buy_qty'        => 1,
    'get_qty'        => 1,
    'discount_type'  => 'percent',
    'discount_value' => 50,
    'scope'          => 'global',
    'categories'     => array(),
    'products'       => array(),
));

?>

<div class="gt-bogo-admin-page">

    <!-- BRANDING HEADER -->
    <div class="gt-bogo-admin-brand-header">
        <img class="gt-bogo-admin-logo"
             src="<?php echo esc_url( 'https://graphictshirts.shop/bogo/icon-512x512.png' ); ?>"
             alt="GT BOGO ENGINE" />

        <div class="gt-bogo-admin-brand-text">
            <h1>GT BOGO ENGINE for WooCommerce</h1>
            <p class="gt-bogo-admin-tagline">Premium BOGO Automation by GRAPHIC T-SHIRTS</p>
        </div>
    </div>

    <h2 class="gt-bogo-admin-title"><?php _e( 'Free Global BOGO Rule', 'gt-bogo-engine' ); ?></h2>

    <form method="post" id="gt-bogo-engine-free-rule-form">

        <div class="gt-bogo-card">

            <h3 class="gt-bogo-card-title"><?php _e( 'Free Rule Configuration', 'gt-bogo-engine' ); ?></h3>

            <!-- ENABLE RULE -->
            <div class="gt-bogo-setting-row">
                <label>
                    <strong><?php _e( 'Enable Free Rule', 'gt-bogo-engine' ); ?></strong>
                </label>

                <label class="gt-bogo-toggle">
                    <input type="checkbox"
                           name="free_rule_enabled"
                           <?php checked( $rule['enabled'], 1 ); ?> />

                    <span class="gt-bogo-slider"></span>
                </label>
            </div>

            <!-- RULE TITLE -->
            <div class="gt-bogo-setting-row">
                <label>
                    <strong><?php _e( 'Rule Title', 'gt-bogo-engine' ); ?></strong>
                </label>

                <input type="text"
                       class="gt-bogo-input"
                       name="free_rule_title"
                       value="<?php echo esc_attr( $rule['title'] ); ?>" />
            </div>

            <!-- BUY QTY -->
            <div class="gt-bogo-setting-row">
                <label>
                    <strong><?php _e( 'Buy Quantity', 'gt-bogo-engine' ); ?></strong>
                </label>

                <input type="number" min="1"
                       class="gt-bogo-input small"
                       name="free_rule_buy_qty"
                       value="<?php echo intval( $rule['buy_qty'] ); ?>" />
            </div>

            <!-- GET QTY -->
            <div class="gt-bogo-setting-row">
                <label>
                    <strong><?php _e( 'Get Quantity', 'gt-bogo-engine' ); ?></strong>
                </label>

                <input type="number" min="1"
                       class="gt-bogo-input small"
                       name="free_rule_get_qty"
                       value="<?php echo intval( $rule['get_qty'] ); ?>" />
            </div>

            <!-- DISCOUNT TYPE -->
            <div class="gt-bogo-setting-row">
                <label>
                    <strong><?php _e( 'Discount Type', 'gt-bogo-engine' ); ?></strong>
                </label>

                <select name="free_rule_discount_type" class="gt-bogo-select">
                    <option value="percent" <?php selected( $rule['discount_type'], 'percent' ); ?>>
                        <?php _e( 'Percent (%)', 'gt-bogo-engine' ); ?>
                    </option>

                    <option value="fixed" <?php selected( $rule['discount_type'], 'fixed' ); ?>>
                        <?php _e( 'Fixed Amount', 'gt-bogo-engine' ); ?>
                    </option>
                </select>
            </div>

            <!-- DISCOUNT VALUE -->
            <div class="gt-bogo-setting-row">
                <label>
                    <strong><?php _e( 'Discount Value', 'gt-bogo-engine' ); ?></strong>
                </label>

                <input type="number" min="0" step="0.01"
                       class="gt-bogo-input small"
                       name="free_rule_discount_value"
                       value="<?php echo esc_attr( $rule['discount_value'] ); ?>" />
            </div>

            <!-- SCOPE -->
            <div class="gt-bogo-setting-row">
                <label>
                    <strong><?php _e( 'Scope', 'gt-bogo-engine' ); ?></strong>
                </label>

                <select name="free_rule_scope" class="gt-bogo-select">
                    <option value="global" <?php selected( $rule['scope'], 'global' ); ?>>
                        <?php _e( 'Entire Store', 'gt-bogo-engine' ); ?>
                    </option>

                    <option value="categories" <?php selected( $rule['scope'], 'categories' ); ?>>
                        <?php _e( 'Specific Categories', 'gt-bogo-engine' ); ?>
                    </option>

                    <option value="products" <?php selected( $rule['scope'], 'products' ); ?>>
                        <?php _e( 'Specific Products', 'gt-bogo-engine' ); ?>
                    </option>
                </select>
            </div>

        </div>

        <!-- SAVE BAR -->
        <div class="gt-bogo-save-bar">
            <button type="submit" class="gt-bogo-btn-primary">
                <?php _e( 'Save Free Rule', 'gt-bogo-engine' ); ?>
            </button>

            <span class="gt-bogo-autosave-status" style="display:none;"></span>
        </div>

        <input type="hidden" name="gt_bogo_engine_context" value="free_rule">

    </form>

</div>
