<?php
/**
 * License / PRO Upgrade Page
 *
 * @package GT_BOGO_Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
require_once dirname( __FILE__ ) . '/partials/brand-header.php';


$nonce = wp_create_nonce( 'gt_bogo_engine_license_nonce' );
$license_key = get_option( 'gt_bogo_engine_license_key', '' );
$license_mgr = null;
$license_status = array();
if ( class_exists( 'GT_BOGO_Engine_License' ) ) {
    $license_mgr = GT_BOGO_Engine_License::instance();
    // Keep the manager in sync with the option used by this page.
    if ( '' !== trim( $license_key ) ) {
        $license_mgr->set_key( $license_key );
    }
    $license_status = $license_mgr->ensure_validated();
}

$license_status = get_option( 'gt_bogo_engine_license_status', 'inactive' );

$status_label = '';
$status_color = '';

switch ( $license_status ) {
    case 'valid':
        $status_label = __( 'Active', 'gt-bogo-engine' );
        $status_color = 'gt-bogo-status-green';
        break;

    case 'invalid':
        $status_label = __( 'Invalid', 'gt-bogo-engine' );
        $status_color = 'gt-bogo-status-red';
        break;

    default:
        $status_label = __( 'Not Activated', 'gt-bogo-engine' );
        $status_color = 'gt-bogo-status-grey';
        break;
}
?>

<div class="wrap gt-bogo-engine-wrap gt-bogo-engine-license-wrap">

    <h1 class="gt-bogo-page-title">
        <span class="gt-bogo-badge">GT</span>
        <?php esc_html_e( 'GT BOGO PRO License', 'gt-bogo-engine' ); ?>
    </h1>

    <p class="gt-bogo-lead">
        <?php esc_html_e( 'Activate your license to unlock premium features, unlimited rules, cheapest-item logic, targeting, stacking, and priority sorting.', 'gt-bogo-engine' ); ?>
    </p>


    <div class="gt-bogo-license-grid">

        <!-- =========================================================
             LEFT SIDE — LICENSE ACTIVATION PANEL
        ========================================================== -->
        <div class="gt-bogo-card">

            <h2><?php esc_html_e( 'License Activation', 'gt-bogo-engine' ); ?></h2>

            <p><?php esc_html_e( 'Enter your GT BOGO PRO license key below to enable premium features.', 'gt-bogo-engine' ); ?></p>

            <label for="gt-bogo-license-key" class="gt-bogo-label">
                <?php esc_html_e( 'License Key', 'gt-bogo-engine' ); ?>
            </label>

            <input
                type="text"
                id="gt-bogo-license-key"
                class="gt-bogo-input"
                placeholder="<?php esc_attr_e( 'Enter license key…', 'gt-bogo-engine' ); ?>"
                value="<?php echo esc_attr( $license_key ); ?>"
            />

            <div class="gt-bogo-license-actions">
                <button
                    id="gt-bogo-activate-license"
                    class="button button-primary"
                    data-nonce="<?php echo esc_attr( $nonce ); ?>"
                >
                    <?php esc_html_e( 'Activate License', 'gt-bogo-engine' ); ?>
                </button>

                <?php if ( $license_status === 'valid' ) : ?>
                    <button
                        id="gt-bogo-deactivate-license"
                        class="button button-secondary"
                        data-nonce="<?php echo esc_attr( $nonce ); ?>"
                    >
                        <?php esc_html_e( 'Deactivate', 'gt-bogo-engine' ); ?>
                    </button>
                <?php endif; ?>
            </div>

            <p class="gt-bogo-license-status <?php echo esc_attr( $status_color ); ?>">
                <?php esc_html_e( 'Status:', 'gt-bogo-engine' ); ?>
                <strong><?php echo esc_html( $status_label ); ?></strong>
            </p>

            <p id="gt-bogo-license-message" class="gt-bogo-status"></p>

        </div><!-- .gt-bogo-card -->


        <!-- =========================================================
             RIGHT SIDE — PRO FEATURES LIST
        ========================================================== -->
        <div class="gt-bogo-card gt-bogo-pro-card">

            <h2><?php esc_html_e( 'Upgrade to GT BOGO PRO', 'gt-bogo-engine' ); ?></h2>

            <p><?php esc_html_e( 'Unlock the full power of the GT BOGO Engine:', 'gt-bogo-engine' ); ?></p>

            <ul class="gt-bogo-pro-features">
                <li>⭐ <?php esc_html_e( 'Unlimited BOGO Rules', 'gt-bogo-engine' ); ?></li>
                <li>⭐ <?php esc_html_e( 'Buy X Get Y Free', 'gt-bogo-engine' ); ?></li>
                <li>⭐ <?php esc_html_e( 'Cheapest item discounts', 'gt-bogo-engine' ); ?></li>
                <li>⭐ <?php esc_html_e( 'Category or product targeting', 'gt-bogo-engine' ); ?></li>
                <li>⭐ <?php esc_html_e( 'Stacking options', 'gt-bogo-engine' ); ?></li>
                <li>⭐ <?php esc_html_e( 'Priority sorting', 'gt-bogo-engine' ); ?></li>
                <li>⭐ <?php esc_html_e( 'Import / Export rules', 'gt-bogo-engine' ); ?></li>
                <li>⭐ <?php esc_html_e( 'Premium Support', 'gt-bogo-engine' ); ?></li>
            </ul>

            <a href="https://graphictshirts.shop/bogo" target="_blank" class="button button-primary gt-bogo-pro-button">
                <?php esc_html_e( 'View PRO Plans', 'gt-bogo-engine' ); ?>
            </a>

        </div><!-- .gt-bogo-card -->

    </div><!-- .gt-bogo-license-grid -->

</div><!-- .gt-bogo-engine-license-wrap -->
