<?php
/**
 * GT BOGO ENGINE – PRO Rules Page
 * Path: /includes/admin/views/page-pro-rules.php
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$rules = get_option( 'gt_bogo_engine_rules', array() );

?>

<div class="gt-bogo-admin-page">

    <!-- BRANDING HEADER -->
    <div class="gt-bogo-admin-brand-header">
        <img class="gt-bogo-admin-logo"
             src="<?php echo esc_url( 'https://graphictshirts.shop/bogo/icon-512x512.png' ); ?>"
             alt="GT BOGO ENGINE" />

        <div class="gt-bogo-admin-brand-text">
            <h1>GT BOGO ENGINE for WooCommerce</h1>
            <p class="gt-bogo-admin-tagline">Premium BOGO Automation by GRAPHIC T-SHIRTS</p>
        </div>
    </div>

    <h2 class="gt-bogo-admin-title"><?php _e( 'PRO BOGO Rules', 'gt-bogo-engine' ); ?></h2>
    <p class="gt-bogo-admin-subtitle">
        <?php _e( 'Create unlimited Buy X Get Y promotional rules with advanced conditions.', 'gt-bogo-engine' ); ?>
    </p>

    <form id="gt-bogo-engine-pro-rules-form" method="post">

        <div id="gt-bogo-engine-pro-rules-wrapper">

            <?php if ( empty( $rules ) ) : ?>

                <div class="gt-bogo-empty">
                    <p><?php _e( 'No PRO rules created yet.', 'gt-bogo-engine' ); ?></p>
                </div>

            <?php endif; ?>

            <?php foreach ( $rules as $index => $rule ) : ?>

                <div class="gt-bogo-pro-rule-card" data-rule-index="<?php echo esc_attr( $index ); ?>">

                    <div class="gt-bogo-pro-rule-header">

                        <h3 class="gt-bogo-pro-rule-title">
                            <?php echo esc_html( $rule['title'] ?? 'BOGO Rule' ); ?>
                        </h3>

                        <div class="gt-bogo-pro-rule-actions">
                            <button type="button" class="gt-bogo-btn-delete gt-bogo-delete-rule" data-index="<?php echo esc_attr( $index ); ?>">
                                ✕
                            </button>
                        </div>
                    </div>

                    <div class="gt-bogo-pro-rule-body">

                        <!-- ENABLE RULE -->
                        <div class="gt-bogo-setting-row">
                            <label><strong><?php _e( 'Enable Rule', 'gt-bogo-engine' ); ?></strong></label>

                            <label class="gt-bogo-toggle">
                                <input type="checkbox"
                                       name="rules[<?php echo esc_attr($index); ?>][enabled]"
                                       <?php checked( $rule['enabled'], 1 ); ?> />

                                <span class="gt-bogo-slider"></span>
                            </label>
                        </div>

                        <!-- TITLE -->
                        <div class="gt-bogo-setting-row">
                            <label><strong><?php _e( 'Rule Title', 'gt-bogo-engine' ); ?></strong></label>

                            <input type="text"
                                   class="gt-bogo-input"
                                   name="rules[<?php echo esc_attr($index); ?>][title]"
                                   value="<?php echo esc_attr( $rule['title'] ); ?>" />
                        </div>

                        <!-- BUY QTY -->
                        <div class="gt-bogo-setting-row">
                            <label><strong><?php _e( 'Buy Quantity', 'gt-bogo-engine' ); ?></strong></label>

                            <input type="number" min="1"
                                   class="gt-bogo-input small"
                                   name="rules[<?php echo esc_attr($index); ?>][buy_qty]"
                                   value="<?php echo intval( $rule['buy_qty'] ); ?>" />
                        </div>

                        <!-- GET QTY -->
                        <div class="gt-bogo-setting-row">
                            <label><strong><?php _e( 'Get Quantity', 'gt-bogo-engine' ); ?></strong></label>

                            <input type="number" min="1"
                                   class="gt-bogo-input small"
                                   name="rules[<?php echo esc_attr($index); ?>][get_qty]"
                                   value="<?php echo intval( $rule['get_qty'] ); ?>" />
                        </div>

                        <!-- DISCOUNT TYPE -->
                        <div class="gt-bogo-setting-row">
                            <label><strong><?php _e( 'Discount Type', 'gt-bogo-engine' ); ?></strong></label>

                            <select class="gt-bogo-select"
                                    name="rules[<?php echo esc_attr($index); ?>][discount_type]">

                                <option value="percent" <?php selected( $rule['discount_type'], 'percent' ); ?>>
                                    <?php _e( 'Percent (%)', 'gt-bogo-engine' ); ?>
                                </option>

                                <option value="fixed" <?php selected( $rule['discount_type'], 'fixed' ); ?>>
                                    <?php _e( 'Fixed Amount', 'gt-bogo-engine' ); ?>
                                </option>

                            </select>
                        </div>

                        <!-- DISCOUNT VALUE -->
                        <div class="gt-bogo-setting-row">
                            <label><strong><?php _e( 'Discount Value', 'gt-bogo-engine' ); ?></strong></label>

                            <input type="number" step="0.01" min="0"
                                   class="gt-bogo-input small"
                                   name="rules[<?php echo esc_attr($index); ?>][discount_value]"
                                   value="<?php echo esc_attr( $rule['discount_value'] ); ?>" />
                        </div>

                        <!-- SCOPE -->
                        <div class="gt-bogo-setting-row">
                            <label><strong><?php _e( 'Scope', 'gt-bogo-engine' ); ?></strong></label>

                            <select class="gt-bogo-select"
                                    name="rules[<?php echo esc_attr($index); ?>][scope]">

                                <option value="global" <?php selected( $rule['scope'], 'global' ); ?>>
                                    <?php _e( 'Entire Store', 'gt-bogo-engine' ); ?>
                                </option>

                                <option value="categories" <?php selected( $rule['scope'], 'categories' ); ?>>
                                    <?php _e( 'Specific Categories', 'gt-bogo-engine' ); ?>
                                </option>

                                <option value="products" <?php selected( $rule['scope'], 'products' ); ?>>
                                    <?php _e( 'Specific Products', 'gt-bogo-engine' ); ?>
                                </option>

                            </select>
                        </div>

                    </div>

                </div>

            <?php endforeach; ?>

        </div>

        <!-- ADD RULE BUTTON -->
        <button type="button" id="gt-bogo-add-pro-rule" class="gt-bogo-btn-secondary">
            + <?php _e( 'Add New PRO Rule', 'gt-bogo-engine' ); ?>
        </button>

        <!-- SAVE BUTTON BAR -->
        <div class="gt-bogo-save-bar">
            <button type="submit" class="gt-bogo-btn-primary">
                <?php _e( 'Save PRO Rules', 'gt-bogo-engine' ); ?>
            </button>

            <span class="gt-bogo-autosave-status" style="display:none;"></span>
        </div>

        <input type="hidden" name="gt_bogo_engine_context" value="pro_rules">

    </form>

</div>
