<?php
/**
 * GT BOGO ENGINE – Settings Page
 * Path: /includes/admin/views/page-settings.php
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$settings = get_option('gt_bogo_engine_settings', array(
    'enable_engine'  => 1,
    'debug_mode'     => 0,
    'pro_nag_hidden' => 0,
));
?>

<div class="gt-bogo-admin-page">

    <!-- BRANDING HEADER -->
    <div class="gt-bogo-admin-brand-header">
        <img class="gt-bogo-admin-logo"
             src="<?php echo esc_url( 'https://graphictshirts.shop/bogo/icon-512x512.png' ); ?>"
             alt="GT BOGO ENGINE" />

        <div class="gt-bogo-admin-brand-text">
            <h1>GT BOGO ENGINE for WooCommerce</h1>
            <p class="gt-bogo-admin-tagline">Premium BOGO Automation by GRAPHIC T-SHIRTS</p>
        </div>
    </div>

    <!-- PAGE TITLE -->
    <h2 class="gt-bogo-admin-title"><?php _e( 'Plugin Settings', 'gt-bogo-engine' ); ?></h2>

    <form method="post" id="gt-bogo-engine-settings-form">

        <div class="gt-bogo-card">

            <h3 class="gt-bogo-card-title"><?php _e( 'General Settings', 'gt-bogo-engine' ); ?></h3>

            <!-- ENABLE ENGINE -->
            <div class="gt-bogo-setting-row">
                <label for="enable_engine">
                    <strong><?php _e( 'Enable BOGO Engine', 'gt-bogo-engine' ); ?></strong>
                </label>

                <label class="gt-bogo-toggle">
                    <input type="checkbox" id="enable_engine" name="enable_engine"
                        <?php checked( $settings['enable_engine'], 1 ); ?> />
                    <span class="gt-bogo-slider"></span>
                </label>
            </div>

            <!-- DEBUG MODE -->
            <div class="gt-bogo-setting-row">
                <label for="debug_mode">
                    <strong><?php _e( 'Debug Mode', 'gt-bogo-engine' ); ?></strong>
                    <p class="gt-bogo-desc">
                        <?php _e( 'Show detailed discount calculations in the cart (admin only).', 'gt-bogo-engine' ); ?>
                    </p>
                </label>

                <label class="gt-bogo-toggle">
                    <input type="checkbox" id="debug_mode" name="debug_mode"
                        <?php checked( $settings['debug_mode'], 1 ); ?> />
                    <span class="gt-bogo-slider"></span>
                </label>
            </div>

            <!-- HIDE PRO NOTICE -->
            <div class="gt-bogo-setting-row">
                <label for="pro_nag_hidden">
                    <strong><?php _e( 'Hide PRO Upsell Notice', 'gt-bogo-engine' ); ?></strong>
                </label>

                <label class="gt-bogo-toggle">
                    <input type="checkbox" id="pro_nag_hidden" name="pro_nag_hidden"
                        <?php checked( $settings['pro_nag_hidden'], 1 ); ?> />
                    <span class="gt-bogo-slider"></span>
                </label>
            </div>

        </div>

        <!-- SAVE BUTTON -->
        <div class="gt-bogo-save-bar">
            <button type="submit" class="gt-bogo-btn-primary">
                <?php _e( 'Save Settings', 'gt-bogo-engine' ); ?>
            </button>

            <span class="gt-bogo-autosave-status" style="display:none;"></span>
        </div>

        <!-- Autosave Context -->
        <input type="hidden" name="gt_bogo_engine_context" value="settings">

    </form>

</div>

