<?php
/**
 * Welcome Screen
 *
 * @package GT_BOGO_Engine
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
require_once dirname( __FILE__ ) . '/partials/brand-header.php';


$settings      = get_option( 'gt_bogo_engine_settings', array() );
$engine_on     = ! empty( $settings['enable_engine'] );
$free_rule     = get_option( 'gt_bogo_engine_free_rule', array() );
$has_free_rule = ! empty( $free_rule );
$pro_rules     = get_option( 'gt_bogo_engine_rules', array() );
$pro_count     = is_array( $pro_rules ) ? count( $pro_rules ) : 0;
?>

<div class="wrap gt-bogo-engine-wrap gt-bogo-engine-welcome-wrap">

    <h1 class="gt-bogo-page-title">
        <?php esc_html_e( 'Welcome to GT BOGO ENGINE for WooCommerce', 'gt-bogo-engine' ); ?>
    </h1>

    <p class="gt-bogo-lead">
        <?php esc_html_e( 'Launch high-converting Buy X Get Y campaigns with a premium UI, built by GRAPHIC T-SHIRTS.', 'gt-bogo-engine' ); ?>
    </p>

    <div class="gt-bogo-welcome-grid">

        <!-- Quick Status -->
        <div class="gt-bogo-card gt-bogo-card-status">
            <h2><?php esc_html_e( 'Engine Status', 'gt-bogo-engine' ); ?></h2>

            <ul class="gt-bogo-status-list">
                <li>
                    <span class="gt-bogo-status-label"><?php esc_html_e( 'Engine:', 'gt-bogo-engine' ); ?></span>
                    <?php if ( $engine_on ) : ?>
                        <span class="gt-bogo-status gt-bogo-status-on"><?php esc_html_e( 'Enabled', 'gt-bogo-engine' ); ?></span>
                    <?php else : ?>
                        <span class="gt-bogo-status gt-bogo-status-off"><?php esc_html_e( 'Disabled', 'gt-bogo-engine' ); ?></span>
                    <?php endif; ?>
                </li>

                <li>
                    <span class="gt-bogo-status-label"><?php esc_html_e( 'Free Core Rule:', 'gt-bogo-engine' ); ?></span>
                    <?php if ( $has_free_rule && ! empty( $free_rule['enabled'] ) ) : ?>
                        <span class="gt-bogo-status gt-bogo-status-on">
                            <?php echo esc_html( $free_rule['title'] ?? __( 'Active', 'gt-bogo-engine' ) ); ?>
                        </span>
                    <?php else : ?>
                        <span class="gt-bogo-status gt-bogo-status-off">
                            <?php esc_html_e( 'Not active yet', 'gt-bogo-engine' ); ?>
                        </span>
                    <?php endif; ?>
                </li>

                <li>
                    <span class="gt-bogo-status-label"><?php esc_html_e( 'PRO Rules:', 'gt-bogo-engine' ); ?></span>
                    <?php if ( $pro_count > 0 ) : ?>
                        <span class="gt-bogo-status gt-bogo-status-on">
                            <?php echo esc_html( sprintf( _n( '%d rule configured', '%d rules configured', $pro_count, 'gt-bogo-engine' ), $pro_count ) ); ?>
                        </span>
                    <?php else : ?>
                        <span class="gt-bogo-status gt-bogo-status-off">
                            <?php esc_html_e( 'No PRO rules yet', 'gt-bogo-engine' ); ?>
                        </span>
                    <?php endif; ?>
                </li>
            </ul>

            <p class="gt-bogo-small">
                <?php esc_html_e( 'You can change these from the Settings, Free Core Rule, and PRO Rules tabs.', 'gt-bogo-engine' ); ?>
            </p>
        </div>

        <!-- Quick Start -->
        <div class="gt-bogo-card gt-bogo-card-quickstart">
            <h2><?php esc_html_e( '3-Step Quick Start', 'gt-bogo-engine' ); ?></h2>

            <ol class="gt-bogo-steps">
                <li>
                    <strong><?php esc_html_e( 'Enable the Engine', 'gt-bogo-engine' ); ?></strong>
                    <span><?php esc_html_e( 'Turn GT BOGO Engine ON so rules can apply to the cart.', 'gt-bogo-engine' ); ?></span>
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=gt-bogo-engine&tab=settings' ) ); ?>" class="button button-secondary gt-bogo-inline-button">
                        <?php esc_html_e( 'Open Settings', 'gt-bogo-engine' ); ?>
                    </a>
                </li>
                <li>
                    <strong><?php esc_html_e( 'Configure the Free Core Rule', 'gt-bogo-engine' ); ?></strong>
                    <span><?php esc_html_e( 'Your plugin includes a permanent free rule: Buy 1 Get 1 at 50% Off (global).', 'gt-bogo-engine' ); ?></span>
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=gt-bogo-engine&tab=free-rule' ) ); ?>" class="button button-secondary gt-bogo-inline-button">
                        <?php esc_html_e( 'Edit Free Core Rule', 'gt-bogo-engine' ); ?>
                    </a>
                </li>
                <li>
                    <strong><?php esc_html_e( 'Add PRO Rules (Optional)', 'gt-bogo-engine' ); ?></strong>
                    <span><?php esc_html_e( 'Create campaign-specific Buy X Get Y promotions by category, products, or cart conditions.', 'gt-bogo-engine' ); ?></span>
                    <a href="<?php echo esc_url( admin_url( 'admin.php?page=gt-bogo-engine&tab=pro-rules' ) ); ?>" class="button button-primary gt-bogo-inline-button">
                        <?php esc_html_e( 'Create PRO Rules', 'gt-bogo-engine' ); ?>
                    </a>
                </li>
            </ol>
        </div>

        <!-- Highlights -->
        <div class="gt-bogo-card gt-bogo-card-features">
            <h2><?php esc_html_e( 'What You Can Do With GT BOGO Engine', 'gt-bogo-engine' ); ?></h2>

            <ul class="gt-bogo-feature-list">
                <li><?php esc_html_e( 'Run store-wide “Buy 1 Get 1 at 50% Off” without coupons.', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Create advanced Buy X Get Y campaigns per category or product.', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Choose between percent or fixed discounts.', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Stack multiple rules and control their priority.', 'gt-bogo-engine' ); ?></li>
                <li><?php esc_html_e( 'Track everything in a clean, branded admin UI.', 'gt-bogo-engine' ); ?></li>
            </ul>

            <p class="gt-bogo-small">
                <?php esc_html_e( 'Need help? Open the documentation from the Docs tab any time.', 'gt-bogo-engine' ); ?>
            </p>

            <a href="<?php echo esc_url( admin_url( 'admin.php?page=gt-bogo-engine&tab=docs' ) ); ?>" class="button">
                <?php esc_html_e( 'Open Documentation', 'gt-bogo-engine' ); ?>
            </a>
        </div>

        <!-- Brand / Support -->
        <div class="gt-bogo-card gt-bogo-card-brand">
            <h2><?php esc_html_e( 'Built by GRAPHIC T-SHIRTS', 'gt-bogo-engine' ); ?></h2>

            <p>
                <?php esc_html_e( 'GT BOGO Engine is built and maintained by GRAPHIC T-SHIRTS, a premium streetwear brand running WooCommerce at scale.', 'gt-bogo-engine' ); ?>
            </p>

            <ul class="gt-bogo-brand-links">
                <li>
                    <a href="https://graphictshirts.shop/bogo" target="_blank" rel="noopener noreferrer">
                        <?php esc_html_e( 'View GT BOGO Engine Sales Page', 'gt-bogo-engine' ); ?>
                    </a>
                </li>
                <li>
                    <a href="mailto:support@graphictshirts.shop">
                        <?php esc_html_e( 'Contact Support', 'gt-bogo-engine' ); ?>
                    </a>
                </li>
                <li>
                    <a href="https://graphictshirts.shop" target="_blank" rel="noopener noreferrer">
                        <?php esc_html_e( 'Visit GRAPHIC T-SHIRTS', 'gt-bogo-engine' ); ?>
                    </a>
                </li>
            </ul>

            <p class="gt-bogo-small gt-bogo-muted">
                <?php esc_html_e( 'Thank you for supporting independent creators. Every installation helps fund new art and development.', 'gt-bogo-engine' ); ?>
            </p>
        </div>

    </div><!-- .gt-bogo-welcome-grid -->

</div><!-- .gt-bogo-engine-welcome-wrap -->
