<?php
/**
 * PRO rules tab view.
 *
 * @var GT_BOGO_Engine $engine
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$rules      = $engine->get_rules();
$categories = get_terms( array(
    'taxonomy'   => 'product_cat',
    'hide_empty' => false,
) );

$products = wc_get_products( array(
    'limit'  => 50,
    'status' => 'publish',
    'orderby'=> 'title',
    'order'  => 'ASC',
) );

global $wp_roles;
$all_roles = $wp_roles ? $wp_roles->roles : array();
?>
<div class="gt-bogo-engine-panel">
    <h2><?php esc_html_e( 'PRO Rules – Advanced BOGO Campaigns', 'gt-bogo-engine' ); ?></h2>
    <p><?php esc_html_e( 'Create multiple rules: Buy X Get Y Free, cheapest-item promotions, scheduled offers, and more.', 'gt-bogo-engine' ); ?></p>

    <form method="post" id="gt-bogo-engine-pro-rules-form">
        <?php wp_nonce_field( 'gt_bogo_engine_save_pro_rules', '_wpnonce' ); ?>
        <input type="hidden" name="gt_bogo_engine_action" value="save_pro_rules"/>

        <div class="gt-bogo-engine-rules-list" data-next-index="<?php echo esc_attr( count( $rules ) ); ?>">

            <?php
            if ( ! empty( $rules ) ) {
                $index = 0;
                foreach ( $rules as $rule_id => $rule ) {
                    include __DIR__ . '/pro-rules-rule-row.php'; // We’ll inline template below if you prefer single file.
                    $index++;
                }
            } else {
                $index = 0;
                $rule  = array(
                    'id'               => '',
                    'enabled'          => 0,
                    'title'            => '',
                    'type'             => 'percent',
                    'buy_qty'          => 1,
                    'get_qty'          => 1,
                    'discount_value'   => 50,
                    'scope'            => 'global',
                    'categories'       => array(),
                    'products'         => array(),
                    'min_subtotal'     => '',
                    'max_subtotal'     => '',
                    'start_date'       => '',
                    'end_date'         => '',
                    'customer_roles'   => array(),
                    'max_applications' => '',
                    'priority'         => 10,
                );
                ?>
                <div class="gt-bogo-engine-rule" data-index="<?php echo esc_attr( $index ); ?>">
                    <?php
                    // Render inline template for first rule (base).
                    include __DIR__ . '/pro-rules-rule-inline.php';
                    ?>
                </div>
                <?php
            }
            ?>
        </div>

        <p>
            <button type="button" class="button button-secondary gt-bogo-engine-add-rule">
                <?php esc_html_e( 'Add New Rule', 'gt-bogo-engine' ); ?>
            </button>
        </p>

        <?php submit_button( __( 'Save PRO Rules', 'gt-bogo-engine' ) ); ?>

        <p class="description">
            <?php esc_html_e( 'Need help? See the full documentation and real-world examples on graphictshirts.shop/bogo.', 'gt-bogo-engine' ); ?>
        </p>
    </form>

    <!-- Hidden template used by admin.js to clone new rules -->
    <script type="text/html" id="tmpl-gt-bogo-engine-rule">
        <div class="gt-bogo-engine-rule" data-index="{{index}}">
            <div class="gt-bogo-engine-rule-header">
                <span class="gt-bogo-engine-rule-handle">☰</span>
                <strong><?php esc_html_e( 'Rule', 'gt-bogo-engine' ); ?> #{{index}}</strong>
                <button type="button" class="button-link-delete gt-bogo-engine-delete-rule">
                    <?php esc_html_e( 'Remove', 'gt-bogo-engine' ); ?>
                </button>
            </div>

            <div class="gt-bogo-engine-rule-body">
                <input type="hidden" name="rules[{{index}}][id]" value=""/>

                <table class="form-table">
                    <tr>
                        <th scope="row">
                            <label><?php esc_html_e( 'Enable', 'gt-bogo-engine' ); ?></label>
                        </th>
                        <td>
                            <label>
                                <input type="checkbox" name="rules[{{index}}][enabled]" value="1" checked="checked"/>
                                <?php esc_html_e( 'Activate this rule', 'gt-bogo-engine' ); ?>
                            </label>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row">
                            <label><?php esc_html_e( 'Rule Name', 'gt-bogo-engine' ); ?></label>
                        </th>
                        <td>
                            <input type="text" name="rules[{{index}}][title]" class="regular-text"
                                   placeholder="<?php esc_attr_e( 'Buy 2 Get 1 Free – Hoodies', 'gt-bogo-engine' ); ?>"/>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row"><?php esc_html_e( 'Type', 'gt-bogo-engine' ); ?></th>
                        <td>
                            <select name="rules[{{index}}][type]">
                                <option value="percent"><?php esc_html_e( 'Percentage discount (%)', 'gt-bogo-engine' ); ?></option>
                                <option value="fixed"><?php esc_html_e( 'Fixed amount discount', 'gt-bogo-engine' ); ?></option>
                                <option value="free_item"><?php esc_html_e( 'Free item (100% off for Get items)', 'gt-bogo-engine' ); ?></option>
                                <option value="cheapest_percent"><?php esc_html_e( 'Cheapest item – percentage off', 'gt-bogo-engine' ); ?></option>
                                <option value="cheapest_fixed"><?php esc_html_e( 'Cheapest item – fixed amount off', 'gt-bogo-engine' ); ?></option>
                            </select>
                            <p class="description">
                                <?php esc_html_e( 'For classic “Buy 2 Get 1 Free”, choose "Free item". For "Buy 3, cheapest 40% off", choose "Cheapest item – percentage off".', 'gt-bogo-engine' ); ?>
                            </p>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row"><?php esc_html_e( 'Buy / Get Quantities', 'gt-bogo-engine' ); ?></th>
                        <td class="gt-bogo-engine-bogo-quantities">
                            <label>
                                <?php esc_html_e( 'Buy', 'gt-bogo-engine' ); ?>
                                <input type="number" min="1" step="1" name="rules[{{index}}][buy_qty]" value="1"/>
                            </label>
                            <span class="gt-bogo-engine-bogo-math">→</span>
                            <label>
                                <?php esc_html_e( 'Get', 'gt-bogo-engine' ); ?>
                                <input type="number" min="1" step="1" name="rules[{{index}}][get_qty]" value="1"/>
                            </label>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row"><?php esc_html_e( 'Discount Value', 'gt-bogo-engine' ); ?></th>
                        <td>
                            <input type="number" step="0.01" name="rules[{{index}}][discount_value]" value="50"/>
                            <p class="description">
                                <?php esc_html_e( 'Meaning depends on the type: % for percent rules, fixed amount for fixed rules.', 'gt-bogo-engine' ); ?>
                            </p>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row"><?php esc_html_e( 'Scope', 'gt-bogo-engine' ); ?></th>
                        <td>
                            <select name="rules[{{index}}][scope]" class="gt-bogo-engine-scope-select">
                                <option value="global"><?php esc_html_e( 'Entire store (all products)', 'gt-bogo-engine' ); ?></option>
                                <option value="categories"><?php esc_html_e( 'Specific categories', 'gt-bogo-engine' ); ?></option>
                                <option value="products"><?php esc_html_e( 'Specific products', 'gt-bogo-engine' ); ?></option>
                            </select>

                            <div class="gt-bogo-engine-scope-block gt-bogo-engine-scope-categories">
                                <label>
                                    <?php esc_html_e( 'Categories', 'gt-bogo-engine' ); ?><br/>
                                    <select name="rules[{{index}}][categories][]" multiple="multiple" style="min-width:260px;">
                                        <?php foreach ( $categories as $cat ) : ?>
                                            <option value="<?php echo esc_attr( $cat->term_id ); ?>">
                                                <?php echo esc_html( $cat->name ); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </label>
                            </div>

                            <div class="gt-bogo-engine-scope-block gt-bogo-engine-scope-products">
                                <label>
                                    <?php esc_html_e( 'Products', 'gt-bogo-engine' ); ?><br/>
                                    <select name="rules[{{index}}][products][]" multiple="multiple" style="min-width:260px;">
                                        <?php foreach ( $products as $product ) : ?>
                                            <option value="<?php echo esc_attr( $product->get_id() ); ?>">
                                                <?php echo esc_html( $product->get_name() ); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </label>
                                <p class="description">
                                    <?php esc_html_e( 'For big catalogs this can be heavy; categories are usually easier.', 'gt-bogo-engine' ); ?>
                                </p>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row"><?php esc_html_e( 'Subtotal Conditions', 'gt-bogo-engine' ); ?></th>
                        <td>
                            <label>
                                <?php esc_html_e( 'Minimum cart subtotal', 'gt-bogo-engine' ); ?>
                                <input type="number" step="0.01" name="rules[{{index}}][min_subtotal]" value=""/>
                            </label>
                            <br/>
                            <label>
                                <?php esc_html_e( 'Maximum cart subtotal', 'gt-bogo-engine' ); ?>
                                <input type="number" step="0.01" name="rules[{{index}}][max_subtotal]" value=""/>
                            </label>
                            <p class="description">
                                <?php esc_html_e( 'Leave blank to ignore. These conditions apply to the selected products/categories in the cart.', 'gt-bogo-engine' ); ?>
                            </p>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row"><?php esc_html_e( 'Schedule', 'gt-bogo-engine' ); ?></th>
                        <td>
                            <label>
                                <?php esc_html_e( 'Start date', 'gt-bogo-engine' ); ?>
                                <input type="date" name="rules[{{index}}][start_date]" value=""/>
                            </label>
                            <br/>
                            <label>
                                <?php esc_html_e( 'End date', 'gt-bogo-engine' ); ?>
                                <input type="date" name="rules[{{index}}][end_date]" value=""/>
                            </label>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row"><?php esc_html_e( 'Customer Roles', 'gt-bogo-engine' ); ?></th>
                        <td>
                            <select name="rules[{{index}}][customer_roles][]" multiple="multiple" style="min-width:260px;">
                                <?php foreach ( $all_roles as $role_key => $role_data ) : ?>
                                    <option value="<?php echo esc_attr( $role_key ); ?>">
                                        <?php echo esc_html( translate_user_role( $role_data['name'] ) ); ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                            <p class="description">
                                <?php esc_html_e( 'Leave blank to apply to all customers. Select one or more roles to limit eligibility.', 'gt-bogo-engine' ); ?>
                            </p>
                        </td>
                    </tr>

                    <tr>
                        <th scope="row"><?php esc_html_e( 'Max Applications & Priority', 'gt-bogo-engine' ); ?></th>
                        <td>
                            <label>
                                <?php esc_html_e( 'Max times this rule can apply per cart', 'gt-bogo-engine' ); ?>
                                <input type="number" min="0" step="1" name="rules[{{index}}][max_applications]" value=""/>
                            </label>
                            <p class="description">
                                <?php esc_html_e( 'Leave blank for unlimited. Use this to cap how many discounted units a customer can get.', 'gt-bogo-engine' ); ?>
                            </p>
                            <label>
                                <?php esc_html_e( 'Priority (lower = earlier)', 'gt-bogo-engine' ); ?>
                                <input type="number" min="1" step="1" name="rules[{{index}}][priority]" value="10"/>
                            </label>
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </script>
</div>
