<?php
/**
 * Settings tab view.
 *
 * @var GT_BOGO_Engine $engine
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$settings = $engine->settings;
?>
<div class="gt-bogo-engine-panel">
    <h2><?php esc_html_e( 'Engine Settings', 'gt-bogo-engine' ); ?></h2>
    <p><?php esc_html_e( 'Turn the GT BOGO Rules Engine on or off, and enable debug mode while testing your offers.', 'gt-bogo-engine' ); ?></p>

    <form method="post">
        <?php wp_nonce_field( 'gt_bogo_engine_save_settings', '_wpnonce' ); ?>
        <input type="hidden" name="gt_bogo_engine_action" value="save_settings"/>

        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="enable_engine"><?php esc_html_e( 'Enable BOGO Engine', 'gt-bogo-engine' ); ?></label>
                </th>
                <td>
                    <label>
                        <input type="checkbox" id="enable_engine" name="enable_engine" value="1"
                            <?php checked( ! empty( $settings['enable_engine'] ) ); ?> />
                        <?php esc_html_e( 'Activate GT BOGO Engine discounts on the front-end.', 'gt-bogo-engine' ); ?>
                    </label>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <label for="debug_mode"><?php esc_html_e( 'Debug Mode', 'gt-bogo-engine' ); ?></label>
                </th>
                <td>
                    <label>
                        <input type="checkbox" id="debug_mode" name="debug_mode" value="1"
                            <?php checked( ! empty( $settings['debug_mode'] ) ); ?> />
                        <?php esc_html_e( 'Show extra logging in the WooCommerce status log while testing.', 'gt-bogo-engine' ); ?>
                    </label>
                    <p class="description">
                        <?php esc_html_e( 'Recommended to keep this off on production stores.', 'gt-bogo-engine' ); ?>
                    </p>
                </td>
            </tr>
        </table>

        <?php submit_button( __( 'Save Settings', 'gt-bogo-engine' ) ); ?>
    </form>
</div>
