<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class GT_BOGO_Cache {

    public static function purge_all() {
        // WordPress object cache
        if ( function_exists( 'wp_cache_flush' ) ) {
            @wp_cache_flush();
        }

        // Common transients
        global $wpdb;
        if ( isset( $wpdb ) && $wpdb instanceof wpdb ) {
            // Delete all transients (safe, but can be heavy; use once on updates/activation only)
            $wpdb->query( "DELETE FROM {$wpdb->options} WHERE option_name LIKE '_transient_gt_bogo_%' OR option_name LIKE '_transient_gtbogo_%' OR option_name LIKE '_site_transient_gt_bogo_%' OR option_name LIKE '_site_transient_gtbogo_%'" );
        }

        // Plugin-specific cache dirs (if any)
        $dirs = array(
            WP_CONTENT_DIR . '/cache/gt-bogo-engine',
            WP_CONTENT_DIR . '/cache/gt-bogo',
            WP_CONTENT_DIR . '/uploads/gt-bogo-cache',
        );
        foreach ( $dirs as $dir ) {
            self::rrmdir( $dir );
        }

        // Popular caching plugins (best-effort)
        if ( function_exists( 'rocket_clean_domain' ) ) { @rocket_clean_domain(); }
        if ( function_exists( 'wp_cache_clear_cache' ) ) { @wp_cache_clear_cache(); } // WP Super Cache

        // OPcache (CLI won't help customers; this runs inside PHP-FPM/Apache process)
        if ( function_exists( 'opcache_reset' ) ) {
            @opcache_reset();
        }
    }

    private static function rrmdir( $dir ) {
        if ( ! $dir || ! is_dir( $dir ) ) { return; }
        $items = @scandir( $dir );
        if ( ! is_array( $items ) ) { return; }
        foreach ( $items as $item ) {
            if ( $item === '.' || $item === '..' ) { continue; }
            $path = $dir . DIRECTORY_SEPARATOR . $item;
            if ( is_dir( $path ) ) { self::rrmdir( $path ); }
            else { @unlink( $path ); }
        }
        @rmdir( $dir );
    }
}
