<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }

class GT_BOGO_Updater {

    const TRANSIENT_KEY = 'gt_bogo_engine_update_meta';

    public static function init() {
        add_filter( 'pre_set_site_transient_update_plugins', array( __CLASS__, 'inject_update' ) );
        add_filter( 'plugins_api', array( __CLASS__, 'plugins_api' ), 20, 3 );

        // Purge caches after plugin/theme/core updates complete
        add_action( 'upgrader_process_complete', array( __CLASS__, 'on_upgrade_complete' ), 10, 2 );
    }

    public static function on_upgrade_complete( $upgrader, $hook_extra ) {
        if ( empty( $hook_extra['type'] ) || $hook_extra['type'] !== 'plugin' ) { return; }
        if ( empty( $hook_extra['plugins'] ) || ! is_array( $hook_extra['plugins'] ) ) { return; }

        $plugin_basename = plugin_basename( GT_BOGO_ENGINE_FILE );
        if ( in_array( $plugin_basename, $hook_extra['plugins'], true ) ) {
            GT_BOGO_Cache::purge_all();
            delete_site_transient( self::TRANSIENT_KEY );
        }
    }

    public static function inject_update( $transient ) {
        if ( ! is_object( $transient ) ) { $transient = new stdClass(); }
        if ( empty( $transient->checked ) || ! is_array( $transient->checked ) ) { return $transient; }

        $plugin = plugin_basename( GT_BOGO_ENGINE_FILE );
        $current = isset( $transient->checked[ $plugin ] ) ? $transient->checked[ $plugin ] : GT_BOGO_ENGINE_VERSION;

        $meta = self::fetch_update_meta();
        if ( ! $meta || empty( $meta['new_version'] ) || empty( $meta['package'] ) ) {
            return $transient;
        }

        if ( version_compare( $meta['new_version'], $current, '>' ) ) {
            $obj = new stdClass();
            $obj->slug        = 'gt-bogo-engine';
            $obj->plugin      = $plugin;
            $obj->new_version = $meta['new_version'];
            $obj->package     = $meta['package'];
            $obj->url         = ! empty( $meta['url'] ) ? $meta['url'] : 'https://graphictshirts.shop/';
            $transient->response[ $plugin ] = $obj;
        }

        return $transient;
    }

    public static function plugins_api( $res, $action, $args ) {
        if ( $action !== 'plugin_information' ) { return $res; }
        if ( empty( $args->slug ) || $args->slug !== 'gt-bogo-engine' ) { return $res; }

        $meta = self::fetch_update_meta();
        if ( ! $meta ) { return $res; }

        $info = new stdClass();
        $info->name          = 'GT BOGO ENGINE';
        $info->slug          = 'gt-bogo-engine';
        $info->version       = ! empty( $meta['new_version'] ) ? $meta['new_version'] : GT_BOGO_ENGINE_VERSION;
        $info->author        = 'GRAPHIC T-SHIRTS';
        $info->homepage      = ! empty( $meta['url'] ) ? $meta['url'] : 'https://graphictshirts.shop/';
        $info->download_link = ! empty( $meta['package'] ) ? $meta['package'] : '';
        $info->sections      = array(
            'description' => ! empty( $meta['description'] ) ? $meta['description'] : 'Premium BOGO & discount rules for WooCommerce.',
            'changelog'   => ! empty( $meta['changelog'] ) ? $meta['changelog'] : '',
        );

        return $info;
    }

    private static function fetch_update_meta() {
        $cached = get_site_transient( self::TRANSIENT_KEY );
        if ( is_array( $cached ) && ! empty( $cached['new_version'] ) ) { return $cached; }

        $endpoint = defined( 'GT_BOGO_ENGINE_UPDATE_ENDPOINT' ) ? GT_BOGO_ENGINE_UPDATE_ENDPOINT : '';
        if ( ! $endpoint ) { return null; }

        $resp = wp_remote_get( $endpoint, array( 'timeout' => 10 ) );
        if ( is_wp_error( $resp ) ) { return null; }
        $code = wp_remote_retrieve_response_code( $resp );
        if ( $code < 200 || $code >= 300 ) { return null; }
        $body = wp_remote_retrieve_body( $resp );
        $data = json_decode( $body, true );
        if ( ! is_array( $data ) ) { return null; }

        // Expected keys: new_version, package, url, description, changelog
        set_site_transient( self::TRANSIENT_KEY, $data, 6 * HOUR_IN_SECONDS );
        return $data;
    }
}
