<?php
/**
 * GT BOGO ENGINE – Hard Uninstall Cleanup
 *
 * Removes all plugin options, transients, and cached data
 * when the plugin is uninstalled via WordPress.
 *
 * WordPress.org–compliant uninstall handler.
 */

if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
    exit;
}

global $wpdb;

/**
 * ---------------------------------------------------------
 * Helper: delete options by LIKE pattern
 * ---------------------------------------------------------
 */
function gtbogo_delete_options_like( $table, $pattern ) {
    global $wpdb;
    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$table} WHERE option_name LIKE %s",
            $pattern
        )
    );
}

/**
 * ---------------------------------------------------------
 * Single-site cleanup
 * ---------------------------------------------------------
 */
gtbogo_delete_options_like( $wpdb->options, 'gt_bogo_%' );
gtbogo_delete_options_like( $wpdb->options, 'gt_bogo_engine_%' );

gtbogo_delete_options_like( $wpdb->options, '_transient_gt_bogo_%' );
gtbogo_delete_options_like( $wpdb->options, '_transient_timeout_gt_bogo_%' );

gtbogo_delete_options_like( $wpdb->options, '_site_transient_gt_bogo_%' );
gtbogo_delete_options_like( $wpdb->options, '_site_transient_timeout_gt_bogo_%' );

$wpdb->delete(
    $wpdb->options,
    [ 'option_name' => 'gt_bogo_engine_installed_version' ],
    [ '%s' ]
);

/**
 * ---------------------------------------------------------
 * Multisite cleanup
 * ---------------------------------------------------------
 */
if ( is_multisite() && isset( $wpdb->sitemeta ) ) {

    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->sitemeta} WHERE meta_key LIKE %s",
            'gt_bogo_%'
        )
    );

    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->sitemeta} WHERE meta_key LIKE %s",
            'gt_bogo_engine_%'
        )
    );

    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->sitemeta} WHERE meta_key LIKE %s",
            '_site_transient_gt_bogo_%'
        )
    );

    $wpdb->query(
        $wpdb->prepare(
            "DELETE FROM {$wpdb->sitemeta} WHERE meta_key LIKE %s",
            '_site_transient_timeout_gt_bogo_%'
        )
    );
}

/**
 * ---------------------------------------------------------
 * Flush WordPress caches
 * ---------------------------------------------------------
 */
if ( function_exists( 'wp_cache_flush' ) ) {
    wp_cache_flush();
}

if ( function_exists( 'flush_rewrite_rules' ) ) {
    flush_rewrite_rules();
}

/**
 * ---------------------------------------------------------
 * Flush common caching plugins (safe, conditional)
 * ---------------------------------------------------------
 */
if ( function_exists( 'rocket_clean_domain' ) ) {
    rocket_clean_domain();
}

if ( function_exists( 'w3tc_flush_all' ) ) {
    w3tc_flush_all();
}

if ( function_exists( 'wp_cache_clear_cache' ) ) {
    wp_cache_clear_cache(); // WP Super Cache
}

if ( class_exists( 'LiteSpeed\Purge' ) ) {
    try {
        \LiteSpeed\Purge::purge_all();
    } catch ( \Throwable $e ) {}
}

if ( function_exists( 'sg_cachepress_purge_cache' ) ) {
    sg_cachepress_purge_cache();
}

if ( function_exists( 'cache_enabler_clear_total_cache' ) ) {
    cache_enabler_clear_total_cache();
}

/**
 * ---------------------------------------------------------
 * Opcache reset (if available)
 * ---------------------------------------------------------
 */
if ( function_exists( 'opcache_reset' ) ) {
    opcache_reset();
}

